

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-container">
    <div class="table-container">
        <table id="popupsTable" class="display">
            <thead>
                <tr>
                    <th>Duration</th>
                    <th>Expire Date</th>
                    <th>Popup Image</th>
                    <th>Change Status</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be inserted here via AJAX -->
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>

<script>
$(document).ready(function() {
    const API_BASE_URL = "<?php echo e($API_BASE_URL); ?>";
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    const adminToken = '<?php echo e(session('admin_api_token')); ?>';

    const table = $('#popupsTable').DataTable({
        processing: true,
        serverSide: false,
        ajax: {
            url: `${API_BASE_URL}/popups`,  // Updated URL for popups
            type: "GET",
            dataSrc: "",
            beforeSend: function(xhr) {
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.setRequestHeader('X-CSRF-TOKEN', csrfToken);
                if (adminToken) {
                    xhr.setRequestHeader('Authorization', `Bearer ${adminToken}`);
                }
            }
        },
        columns: [
            { data: "duration" },  // Duration for popup
            { data: "expire_date" },  // Expiry date of popup
            {
                data: "popup_image",  // Image source for the popup
                render: function(data) {
                    return `<img src="/${data}" width="100" alt="Popup Image">`;  // Render image
                }
            },
            {
            data: "status",
            render: function(data, type, row) {
                const btnClass = data === 'active' ? 'btn-success' : 'btn-danger';
                const label = data === 'active' ? 'Active' : 'Inactive';
                return `
                    <button class="toggle-status-btn ${btnClass}" data-id="${row.id}">
                        ${label}
                    </button>
                `;
            }
             },
            {
                data: "id",
                render: function(id) {
                    return `<button class="delete-btn" data-id="${id}" style="color: red;">Delete</button>`;
                }
            }
        ]
    });

    // Handle status toggle
    $('#popupsTable tbody').on('click', '.toggle-status-btn', function() {
        const popupId = $(this).data('id');

        $.ajax({
            url: `${API_BASE_URL}/change/status/popup/${popupId}`,
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': csrfToken,
                'Accept': 'application/json',
                ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
            },
            success: function(response) {
                alert(response.message);
                $('#popupsTable').DataTable().ajax.reload();
            },
            error: function(xhr) {
                alert('Error changing status');
                console.error(xhr.responseJSON || xhr);
            }
        });
    });

    
    // 🔹 Handle delete click
    $('#popupsTable').on('click', '.delete-btn', function() {
        const PopupId = $(this).data('id');

        if (confirm('Are you sure you want to delete this banner?')) {
            $.ajax({
                url: `${API_BASE_URL}/popups/${PopupId}`,
                type: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json',
                    ...(adminToken && { 'Authorization': `Bearer ${adminToken}` })
                },
                success: function(response) {
                    alert('Popup deleted successfully.');
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errorMessage = xhr.responseJSON?.message || 'Failed to delete banner.';
                    alert('Error: ' + errorMessage);
                }
            });
        }
    });

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsols/public_html/api.microsols.com/resources/views/admin/popup.blade.php ENDPATH**/ ?>