<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserGameStats extends Model
{
    use HasFactory;

    protected $table = 'user_game_stats';

    protected $fillable = [
        'user_id',
        'game_name',
        'games_played',
        'games_won_easy',
        'games_won_medium',
        'games_won_hard',
        'best_try',
        'current_streak',
        'max_streak',
        'last_played_at',
        'level',
        'achivements'
    ];
    

    protected $casts = [
        'last_played_at' => 'datetime:Y-m-d H:i:s',
        'achivements' => 'array',
    ];
    

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
