<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_game_stats', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('game_name');
            $table->json('achivements')->nullable();
            $table->integer('games_played')->default(0);
            
            // ✅ Track wins separately for each difficulty
            $table->integer('games_won_easy')->default(0);
            $table->integer('games_won_medium')->default(0);
            $table->integer('games_won_hard')->default(0);
            
            $table->integer('best_try')->default(0);
            $table->integer('current_streak')->default(0);
            $table->integer('max_streak')->default(0);
            $table->date('last_played_at')->nullable();
            
            // ✅ Separate levels per difficulty
            $table->integer('level')->default(1);
            
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_game_stats');
    }
};
