@extends('admin.layout.base')

@section('content')
<div class="content-container">
  <div class="stat-cards-wrapper">

    {{-- Users --}}
    <div class="stat-card">
      <div>
        <h3>Users</h3>
        <h2>{{ $userCount }}</h2>
      </div>
      <div>
        <img src="{{ asset('/assets/images/line-image.png') }}" alt="line image" />
        <div class="bottom-card-text">
          Updated This Week
          <span style="color: {{ $userGrowth['direction'] === 'up' ? 'green' : 'red' }}">
          <img src="{{ asset('/assets/images/icons/arrow-up.png') }}" alt="arrow-up" />
            {{ $userGrowth['percent'] }}%
          </span>
        </div>
      </div>
    </div>

    {{-- Banners --}}
    <div class="stat-card">
      <div>
        <h3>Banners</h3>
        <h2>{{ $bannerCount }}</h2>

        <div class="bottom-card-text">
          Updated This Week
          <span style="color: {{ $bannerGrowth['direction'] === 'up' ? 'green' : 'red' }}">
          <img src="{{ asset('/assets/images/icons/arrow-up.png') }}" alt="arrow-up" />
            {{ $bannerGrowth['percent'] }}%
          </span>
        </div>

      </div>
      <div>
        <img src="{{ asset('/assets/images/bars-top.png') }}" alt="bars" />
      </div>
    </div>

    {{-- Notifications --}}
    <div class="stat-card">
      <div>
        <h3>Notifications</h3>
        <h2>{{ $notificationCount }}</h2>
      </div>
      <div>
        <img src="{{ asset('/assets/images/line-image.png') }}" alt="line image" />
        <div class="bottom-card-text">
          Updated This Week
          <span style="color: {{ $notificationGrowth['direction'] === 'up' ? 'green' : 'red' }}">
          <img src="{{ asset('/assets/images/icons/arrow-up.png') }}" alt="arrow-up" />
            {{ $notificationGrowth['percent'] }}%
          </span>
        </div>
      </div>
    </div>

    {{-- Popups --}}
    <div class="stat-card">
      <div>
        <h3>Popups</h3>
        <h2>{{ $popupCount }}</h2>
        <div class="bottom-card-text">
          Updated This Week
          <span style="color: {{ $popupGrowth['direction'] === 'up' ? 'green' : 'red' }}">
          <img src="{{ asset('/assets/images/icons/arrow-up.png') }}" alt="arrow-up" />
            {{ $popupGrowth['percent'] }}%
          </span>
        </div>
      </div>
      <div>
        <img src="{{ asset('/assets/images/bars-top.png') }}" alt="bars" />
      </div>
    </div>
    

  </div>
</div>
@endsection
