<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\UserGameStatsController;
use App\Http\Controllers\ChallengeController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PopupController;

/*
|--------------------------------------------------------------------------
| Public Routes (No Authentication)
|--------------------------------------------------------------------------
*/
Route::post('/register', [UserController::class, 'register']); // User registration
Route::post('/login', [UserController::class, 'login']); // User login
Route::get('/banners/get', [BannerController::class, 'getBannersApp']);
/*
|--------------------------------------------------------------------------
| Protected Routes (Require Authentication)
|--------------------------------------------------------------------------
*/
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [UserController::class, 'logout']); // Logout
    Route::post('/save/game/stats', [UserGameStatsController::class, 'saveGameStats']);

    Route::post('/users', [UserController::class, 'updateUser']); // Update user
    Route::delete('/users/{id}', [UserController::class, 'deleteUser']); // Delete user (Admin only)
    Route::get('/users', [UserController::class, 'getUsers']); // Get all banners
    Route::post('change/status/user/{id}', [UserController::class, 'changeStatusUser']);
    // Banners
    
    Route::get('/banners', [BannerController::class, 'getBanners']); // Get all banners
    Route::get('/banners/{id}', [BannerController::class, 'getBannerById']); // Get single banner
    Route::post('/banners', [BannerController::class, 'createBanner']); // Create a banner
    Route::put('/banners/{id}', [BannerController::class, 'updateBanner']); // Update a banner
    Route::delete('/banners/{id}', [BannerController::class, 'deleteBanner']); // Delete a banner
    
    // Notification
    //Route::post('/send/notification', [NotificationController::class, 'send']); // Create a banner
    Route::post('/update/token', [NotificationController::class, 'updateToken']); // Create a banner

    Route::get('/notifications/get', [NotificationController::class, 'getNotifications']);
    Route::get('/notifications/{id}', [NotificationController::class, 'getNotificationById']);
    Route::post('/notifications/send', [NotificationController::class, 'createNotification']);
    Route::put('/notifications/{id}', [NotificationController::class, 'updateNotification']);
    Route::delete('/notifications/{id}', [NotificationController::class, 'deleteNotification']);

    Route::post('/challenges/create', [ChallengeController::class, 'createChallenge']);
    Route::get('/challenges/{code}', [ChallengeController::class, 'getChallenge']);
    Route::post('/challenges/update/status', [ChallengeController::class, 'updateChallengeStatus']);
    Route::post('/challenge/join', [ChallengeController::class, 'joinChallenge']);
    Route::post('/challenge/update/result', [ChallengeController::class, 'updateChallengeResult']);

    Route::get('/popups/get', [PopupController::class, 'getPopupsApp']);
    Route::get('/popups', [PopupController::class, 'getPopups']);
    Route::get('/popups/{id}', [PopupController::class, 'getPopupById']);
    Route::post('/popups', [PopupController::class, 'createPopup']);
    Route::put('/popups/{id}', [PopupController::class, 'updatePopup']);
    Route::delete('/popups/{id}', [PopupController::class, 'deletePopup']);
    Route::post('change/status/popup/{id}', [PopupController::class, 'changeStatusPopup']);
});
