<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Challenge extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'creator_id', 'game_name', 'challenge_data', 'challenging_row',
        'challenge_time', 'status', 'challenge_code'
    ];

    public function creator() {
        return $this->belongsTo(User::class, 'creator_id');
    }
}
