<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Dashboard</title>
    @stack('styles')
   <link rel="stylesheet" href="{{ url('/assets/css/style.css') }}?v={{ filemtime(public_path('assets/css/style.css')) }}" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

  </head>
  <body>
    <header class="header">
      <div class="logo-wrapper">
        <h2 class="logo-text">Numberlee</h2>
      </div>
      <div class="header-content-wrapper">
       
        <div class="header-content">
          <div class="user-content-container">
            <div class="user-details">
              <h2>Welcome Back ! {{ ucwords(auth()->user()->fullname) }}</h2>
              <h4>{{ auth()->user()->email }}</h4>
            </div>
          </div>
          <div class="search-icons-container">
            <div class="icon-container" id="logoutBtn">
              <img src="{{url("assets/images/icons/logout.png")}}" alt="logout" />
            </div>
          </div>
        </div>
      </div>
    </header>
    <div class="content-wrapper">
    <aside class="side-navigation">
  <div>
    {{-- Dashboard --}}
    <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'link-active' : '' }}">
      <img src="{{ url('assets/images/icons/dashboard-icon.png') }}" alt="dashboard-icon" />
      <span>Dashboard</span>
    </a>

    {{-- Banners --}}
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown {{ request()->routeIs('banners', 'banners.add') ? 'link-active' : '' }}">
        <img src="{{ url('assets/images/icons/users-icon.png') }}" alt="users-icon" />
        <span>Banners</span>
        <img src="{{ url('assets/images/icons/icon-dropdown.png') }}" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="{{ route('banners') }}" class="{{ request()->routeIs('banners') ? 'link-active' : '' }}">All Banners</a>
        <a href="{{ route('banners.add') }}" class="{{ request()->routeIs('banners.add') ? 'link-active' : '' }}">Add Banner</a>
      </div>
    </div>

    {{-- Notifications --}}
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown {{ request()->routeIs('notifications', 'notifications.add') ? 'link-active' : '' }}">
        <img src="{{ url('assets/images/icons/users-icon.png') }}" alt="users-icon" />
        <span>Notifications</span>
        <img src="{{ url('assets/images/icons/icon-dropdown.png') }}" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="{{ route('notifications') }}" class="{{ request()->routeIs('notifications') ? 'link-active' : '' }}">All Notifications</a>
        <a href="{{ route('notifications.add') }}" class="{{ request()->routeIs('notifications.add') ? 'link-active' : '' }}">Send Notification</a>
      </div>
    </div>

    {{-- Popups --}}
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown {{ request()->routeIs('popup', 'popup.add') ? 'link-active' : '' }}">
        <img src="{{ url('assets/images/icons/users-icon.png') }}" alt="users-icon" />
        <span>Popups</span>
        <img src="{{ url('assets/images/icons/icon-dropdown.png') }}" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="{{ route('popup') }}" class="{{ request()->routeIs('popup') ? 'link-active' : '' }}">All Popups</a>
        <a href="{{ route('popup.add') }}" class="{{ request()->routeIs('popup.add') ? 'link-active' : '' }}">Send Popup</a>
      </div>
    </div>

    {{-- Users --}}
    <div class="dropdown-link-wrapper">
      <a href="#" class="nav-link nav-link-dropdown {{ request()->routeIs('users', 'users.add') ? 'link-active' : '' }}">
        <img src="{{ url('assets/images/icons/users-icon.png') }}" alt="users-icon" />
        <span>Users</span>
        <img src="{{ url('assets/images/icons/icon-dropdown.png') }}" alt="dropdown-arrow" class="dropdown-icon" />
      </a>
      <div class="dropdown-link-body">
        <a href="{{ route('users') }}" class="{{ request()->routeIs('users') ? 'link-active' : '' }}">All Users</a>
        {{-- <a href="{{ route('users.add') }}" class="{{ request()->routeIs('users.add') ? 'link-active' : '' }}">Add User</a> --}}
      </div>
    </div>

    {{-- Settings --}}
    <a href="{{ route('admin.profile') }}" class="nav-link {{ request()->routeIs('admin.profile') ? 'link-active' : '' }}">
      <img src="{{ url('assets/images/icons/gear-icon.png') }}" alt="gear-icon" />
      <span>Profile Setting</span>
    </a>

  </div>
</aside>
