const PresentCard = ({ title, value, icon, percentage, altText }) => {
  return (
    <div className="stat-card">
      <div className="stat-top">
        <div>
          <h3>{title}</h3>
          <h2>{value}</h2>
          <div className="bottom-card-text m-c t-white">
            Updated Today
            <span>
              <img src={icon} alt={altText} />
              {percentage}%
            </span>
          </div>
        </div>
        <div>
          <img
            src="./assets/images/icons/bars-top.svg"
            className="bars-top"
            style={{ marginRight: "25px" }}
            alt="bars"
          />
        </div>
      </div>
      <div className="bottom-card-text d-c t-white">
        Updated Today
        <span>
          <img src="./assets/images/icons/arrow-up-white.png" alt="arrow-up" />
          25%
        </span>
      </div>
    </div>
  );
};

const StatCard = ({ title, value, icon, percentage, altText }) => {
  return (
    <div className="stat-card">
      <div className="stat-top">
        <div>
          <h3>{title}</h3>
          <h2>{value}</h2>
        </div>
        <div>
          <img src={icon} className="ling-graph" alt={altText} />
          <div className="bottom-card-text m-c">
            Updated Today
            <span>
              <img src="./assets/images/icons/arrow-up.png" alt="arrow-up" />
              {percentage}%
            </span>
          </div>
        </div>
      </div>
      <div className="bottom-card-text d-c">
        Updated Today
        <span>
          <img src="./assets/images/icons/arrow-up.png" alt="arrow-up" />
          {percentage}%
        </span>
      </div>
    </div>
  );
};

// Main Component
const StatCards = () => {
  const statData = [
    {
      title: "Employee",
      value: "2585.00",
      icon: "./assets/images/icons/line-image.svg",
      percentage: 25,
      altText: "line image",
      componentFlag: "statCard", // Flag indicating the component to render
    },
    {
      title: "Present",
      value: "25",
      icon: "./assets/images/icons/arrow-up-white.png",
      percentage: 25,
      altText: "line image",
      componentFlag: "presentCard",
    },
    {
      title: "Absent",
      value: "25.000",
      icon: "./assets/images/icons/line-image.svg",
      percentage: 25,
      altText: "line image",
      componentFlag: "statCard",
    },
    {
      title: "On Leave",
      value: "25.000",
      icon: "./assets/images/icons/line-image.svg",
      percentage: 25,
      altText: "line image",
      componentFlag: "statCard",
    },
  ];

  return (
    <div className="stat-container">
      {statData.map((stat, index) => {
        if (stat.componentFlag === "statCard") {
          return (
            <StatCard
              key={index}
              title={stat.title}
              value={stat.value}
              icon={stat.icon}
              percentage={stat.percentage}
              altText={stat.altText}
            />
          );
        } else if (stat.componentFlag === "presentCard") {
          return (
            <PresentCard
              key={index}
              title={stat.title}
              value={stat.value}
              icon={stat.icon}
              percentage={stat.percentage}
              altText={stat.altText}
            />
          );
        }
        return null;
      })}
    </div>
  );
};

export { StatCards };
