import { Poppins, Inter, Roboto } from "next/font/google";
import localFont from "next/font/local";

const helvetica = localFont({
  src: [
    {
      path: "../../public/assets/fonts/Helvetica/Helvetica.ttf",
      weight: "400",
      style: "normal",
    },
    {
      path: "../../public/assets/fonts/Helvetica/Helvetica-Bold.ttf",
      weight: "700",
      style: "normal",
    },
  ],
  variable: "--font-helvetica",
  display: "swap",
});

const segoe = localFont({
  src: "../../public/assets/fonts/Segoe/segoeuithis.ttf",
  weight: "400",
  style: "normal",
  variable: "--font-segoe",
  display: "swap",
});

const poppins = Poppins({
  subsets: ["latin"],
  weight: ["100", "200", "300", "400", "500", "600", "700", "800", "900"],
  variable: "--font-poppins",
  display: "swap",
});

const inter = Inter({
  subsets: ["latin"],
  weight: ["100", "200", "300", "400", "500", "600", "700", "800", "900"],
  variable: "--font-inter",
  display: "swap",
});

const roboto = Roboto({
  subsets: ["latin"],
  weight: ["100", "200", "300", "400", "500", "600", "700", "800", "900"],
  variable: "--font-roboto",
  display: "swap",
});


export const fonts = {
    helvetica,
    segoe,
    poppins,
    inter,
    roboto,
};