<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Employee extends Model
{
    use HasFactory;

    protected $table = 'employee'; 
    
    protected $fillable = [
        'joining_date',
        'total_leaves',
        'user_profile_id',
        'salary_type_id',
        'salary',
        'department_id',
        'designation_id',
        'allowances_id',
        'shift_id',
        'job_type_id',
        'org_id'
    ];

    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];

    // Define the relationship to UserProfile
    public function userProfile()
    {
        return $this->belongsTo(UserProfile::class, 'user_profile_id');
    }

    // Define the relationship to SalaryType
    public function salaryType()
    {
        return $this->belongsTo(Salary_Type::class, 'salary_type_id');
    }


    // Define the relationship to Department
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    // Define the relationship to Designation
    public function designation()
    {
        return $this->belongsTo(Designation::class, 'designation_id');
    }

    // Define the relationship to Allowance
    public function allowances()
    {
        return $this->belongsTo(Allowance::class, 'allowances_id');
    }

    // Define the relationship to Shift
    public function shift()
    {
        return $this->belongsTo(Shift::class, 'shift_id');
    }


    // Define the relationship to JobType
    public function jobType()
    {
        return $this->belongsTo(JobType::class, 'job_type_id');
    }

    // Define the relationship to Education (if only one education record per employee)
    public function education()
    {
        return $this->hasOne(Education::class, 'employee_id', 'id');
    }

    // Define the relationship to WorkHistory (if only one work history record per employee)
    public function workHistory()
    {
        return $this->hasOne(WorkHistory::class, 'employee_id', 'id');
    }



    public function increments()
    {
        return $this->hasMany(Increment::class)->where('org_id', Auth::user()->org_id);
    }

    public function bonus()
    {
        return $this->hasMany(Bonus::class)->where('org_id', Auth::user()->org_id);;
    }

    // Define the relationship to deductions
    public function deducations()
    {
        return $this->hasMany(Deducation::class)->where('org_id', Auth::user()->org_id);;
    }

    // Define the relationship to loans
    public function loans()
    {
        return $this->hasMany(Loan::class)->where('org_id', Auth::user()->org_id);;
    }
}
