<?php

namespace App\Models\Settings;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Leave extends Model
{
    use HasFactory;

    // Define the table associated with the model
    protected $table = 'leaves';

    // Define the fillable attributes
    protected $fillable = [
        'org_id',
        'user_id',
        'leave_type_id',
        'reason',
        'start_date',
        'end_date',
        'leave_status',
        'status'
    ];

    public function organization()
    {
        return $this->belongsTo(Organization::class, 'org_id');
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

 
    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }
}
