<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
   
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('org_id');
            $table->foreign('org_id')->references('id')->on('organizations')->onDelete('cascade');
            $table->unsignedBigInteger('employee_id');
            $table->foreign('employee_id')->references('id')->on('employee')->onDelete('cascade');
            $table->string('salary');
            $table->string('increments');
            $table->string('deductions');
            $table->string('allowances');
            $table->string('loan_amount');
            $table->string('loan_installment');
            $table->string('bonus_amount');
            $table->string('unpaid_leaves');
            $table->string('leave_deduction');
            $table->string('net_pay');
            $table->string('tax');
            $table->string('net_pay_after_tax');
            $table->string('salary_comment');
            $table->string('days')->default('30');
            $table->string('salary_month');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
