<?php
namespace App\DataTables;

use Yajra\DataTables\DataTableAbstract;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Services\DataTable;
use Illuminate\Support\Facades\Http;

class LeaveDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param DataTableAbstract $query
     */
    public function dataTable($query): DataTableAbstract
    {
        return datatables()->of($query)
        ->addColumn('user_name', function ($leave) {
            return $leave['user']['name'];
        })
        ->addColumn('leave_type_name', function ($leave) {
            return $leave['leave_type']['name'];
        });
    
    
    }

    /**
     * Get the query source of dataTable.
     *
     * @return \Illuminate\Support\Collection
     */
    public function query()
    {
        // Fetch data from the external API
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("$apiBaseUrl/leaves");
       
        // Check if the response is successful
        if ($response->successful()) {
            // Return the JSON data from 'leaves' key
            return collect($response->json()['leaves']);
        }

        // Return an empty collection if the API call fails
        return collect([]);
    }

    /**
     * Optional method if you want to use the HTML builder.
     */
    public function html(): HtmlBuilder
    {
        return $this->builder()
                    ->setTableId('leave_table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->orderBy(1)
                    ->selectStyleSingle();
    }

    /**
     * Get the DataTable columns definition.
     */
    public function getColumns(): array
    {
        return [
            Column::make('id'),
            Column::make('user_name')->title('User Name'), // Display user name
            Column::make('leave_type_name')->title('Leave Type Name'), // Display leave type name
            Column::make('user_id'),
            Column::make('leave_type_id'),
            Column::make('leave_status'),
            Column::make('reason'),
            Column::make('start_date'),
            Column::make('end_date'),
            Column::make('status'),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'Leave_' . date('YmdHis');
    }
}
