<?php

namespace App\Providers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\ServiceProvider;

class ExpenseCountProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot()
    {
        // Pass data only to the 'admin.layout.header' view
        view()->composer('admin.layout.header', function ($view) {
            // Get the token from the session
            $token = session('bearer_token');

            // Get the base URL for the API from the .env file
            $apiBaseUrl = env('API_BASE_URL');

            // Call the API to get leaves data
            $response = Http::withToken($token)->get("{$apiBaseUrl}/incomes/search?type=employee_expense");

            // Check if the API request was successful
            if ($response->successful()) {
                $leaves = $response->json(['incomes']);

                // Filter for all leaves where 'status' is 'pending'
                $PendingExepenseCount = collect($leaves)->filter(function ($leave) {
                    return $leave['status'] == 'pending';
                })->count();

                // Share the pending leaves count with the view 'admin.layout.header'
                $view->with('PendingExepenseCount', $PendingExepenseCount);
            } else {
                // Default to 0 if the API request fails
                $view->with('PendingExepenseCount', 0);
            }
        });
    }
}
