@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Deduction List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_deduction" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Deduction</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Deduction List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="deduction_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Employee</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Reason</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createDeduction" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Deduction</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addDeductionForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <label for="">Employee</label>
                        <select type="text" class="form-control employee_id" id="employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee['id'] }}">{{ $employee['name'] }}</option>
                            @endforeach
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date"
                            placeholder="Enter date" required></input>

                        <label class="mt-4">Reason</label>
                        <textarea class="form-control" type="text" id="reason" name="reason" rows="5" placeholder="Enter Reason"
                            required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateDeduction" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Deduction</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateDeductionForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <input type="hidden" name="deduction_id" id="deduction_id">

                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="update_employee_id" name="employee_id"
                             required>
                            <option selected disabled>Select Employe</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee['id'] }}">{{ $employee['name'] }}</option>
                            @endforeach
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>


                        <label class="mt-4">Reson</label>
                        <textarea class="form-control" type="text" id="update_reason" name="reason" rows="5"
                            placeholder="Enter reason" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('js')
        <script>
            $(document).ready(function() {
                var session_data = @json(session()->all());
                $('#deduction_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ env('API_BASE_URL') }}/deductions/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '{{ route('restore_session_data') }}',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        logo: session_data.logo,
                                        currency: session_data.currency,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                           
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },

                        {
                            data: 'reason',
                            name: 'reason'
                        },
                       
                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editdeductbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_deduction').on('click', function() {
                    $('#createDeduction').modal('show');
                });
                $('#addDeductionForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addDeductionForm button[type="submit"]');
                    $submitButton.prop('disabled', true);
                    var employeeId = $('.employee_id').val();
                    if (!employeeId) {
                        toastr.error('Please select an employee.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }
                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_deduction_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createDeduction').modal('hide');
                                $('#deduction_table').DataTable().ajax.reload();
                                $('#addDeductionForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {

                                let firstError = response.errors.deduction ? response.errors.deduction[0] :
                                    'An error occurred.';
                                toastr.error(firstError); 
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the deduction.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });
                $('body').on('click', '#delete_deduction', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('delete_deduction', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {
                            $('#deduction_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Deduction deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Deduction.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editdeductbtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_deduction', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateDeduction').modal('hide');
                                toastr.error('Deduction not found.');
                            } else {
                                $('#updateDeduction').modal('show');
                                var deduction =
                                    response; 
                                $('#deduction_id').val(deduction.id);
                                $('#update_employee_id').val(deduction.employee_id);
                                $('#update_amount').val(deduction.amount);
                                $('#update_reason').val(deduction.reason);
                                $('#update_date').val(deduction.date);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Deduction.');
                        }
                    });
                });

                $('#updateDeductionForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#deduction_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateDeductionForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_deduction_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateDeduction').modal('hide');
                                $('#deduction_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateDeductionForm')[0].reset();
                            } else {
                                // Handle non-validation errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                // Get the first error message from the 'shift' field
                                let firstError = response.errors.deduction ? response.errors.deduction[0] :
                                    'An error occurred.';
                                toastr.error(firstError); // Show the error message
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the deduction.');
                            }
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    @endpush
@endsection
