<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Loan List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_loans" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Loan</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Loan List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="loan_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>id</th>
                                            <th>Employee</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Reason</th>
                                            <th>Terms</th>
                                            <th>Installments</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createloans" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Loan</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addLoanForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="employee_id" name="employee_id"
                            placeholder="Enter Education" required>
                            <option selected disabled>Select Employe</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount" placeholder="Enter amount"
                            required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date" placeholder="Enter date"
                            required></input>


                        <label class="mt-4">Terms</label>
                        <input class="form-control" type="text" id="terms" name="terms" placeholder="Enter terms"
                            required></input>


                        <label class="mt-4">Installments</label>
                        <input class="form-control" type="number" id="installment" name="installment"
                            placeholder="Enter installment" required></input>


                        <label class="mt-4">Reason</label>
                        <textarea class="form-control" type="text" id="reason" name="reason" rows="5" placeholder="Enter Reason"
                            required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateLoan" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Loan</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateLoanForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="loan_id" id="loan_id">

                        <label for="">Employee</label>
                        <select type="text" class="form-control" id="update_employee_id" name="employee_id" required>
                            <option selected disabled>Select Employe</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee['id']); ?>"><?php echo e($employee['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label class="mt-4">Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>

                        <label class="mt-4">Terms</label>
                        <input class="form-control" type="text" id="update_terms" name="terms"
                            placeholder="Enter terms" required></input>

                        <label class="mt-4">Installments</label>
                        <input class="form-control" type="number" id="update_installment" name="installment"
                            placeholder="Enter installments" required></input>

                        <label class="mt-4">Reson</label>
                        <textarea class="form-control" type="text" id="update_reason" name="reason" rows="5"
                            placeholder="Enter reason" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Bootstrap Large Modal -->
    <div class="modal fade" id="loanReportModal" tabindex="-1" role="dialog" aria-labelledby="loanReportModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="loanReportModalLabel">Loan Report</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table-bordered table">
                        <thead>
                            <tr>
                                <th>Pay Date</th>
                                <th>Loan Amount</th>
                                <th>Paid Amount</th>
                                <th>Remaining Amount</th>
                                <th>Remaining Installment</th>
                            </tr>
                        </thead>
                        <tbody id="loanReportTableBody">
                            <!-- Data will be inserted here -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                var session_data = <?php echo json_encode(session()->all(), 15, 512) ?>;

                $('#loan_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '<?php echo e(env('API_BASE_URL')); ?>/loans/index',
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', session_data.bearer_token);
                        },
                        complete: function(response) {
                            // After the API call is complete, restore the session data
                            if (response.status === 200) {
                                $.ajax({
                                    type: 'GET',
                                    url: '<?php echo e(route('restore_session_data')); ?>',
                                    data: {
                                        bearer_token: session_data.bearer_token,
                                        role: session_data.role,
                                        permissions: session_data.permissions,
                                        org_id: session_data.org_id,
                                        id: session_data.id,
                                        logo: session_data.logo,
                                        employee_id: session_data.employee_id,
                                        user_name: session_data.user_name,
                                        designation: session_data.designation,
                                    },
                                    success: function(data) {
                                        if (data.success) {
                                            console.log("Session restored successfully");
                                        } else {
                                            console.error("Failed to restore session");
                                        }
                                        console.log(data);
                                    },
                                    error: function(xhr) {
                                        console.error("Error restoring session:", xhr);
                                    }
                                });

                            }
                        }
                    },
                    columns: [{
                            data: 'count',
                            name: 'count'
                        },
                        {
                            data: 'id',
                            name: 'id',
                            visible: false
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },

                        {
                            data: 'reason',
                            name: 'reason'
                        },
                        {
                            data: 'terms',
                            name: 'terms'
                        },
                        {
                            data: 'installment',
                            name: 'installment'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },

                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editloanbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="loan_report"  class="dropdown-item text-primary">
                                    <i class="fa fa-eye mr-2"></i> Loan Report
                                </button>
                              
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_loans').on('click', function() {
                    $('#createloans').modal('show');
                });
                $('#addLoanForm').on('submit', function(e) {
                    e.preventDefault();
                    var employeeId = $('#employee_id').val();
                    if (!employeeId) {
                        toastr.error('Please select an employee.');
                        $submitButton.prop('disabled', false); // Re-enable the submit button
                        return;
                    }
                    let $submitButton = $('#addLoanForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('add_loan_form')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createloans').modal('hide');
                                $('#loan_table').DataTable().ajax.reload();
                                $('#addLoanForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {

                                let firstError = response.errors.loan ? response.errors.loan[0] :
                                    'An error occurred.';
                                toastr.error(firstError);
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the loan.');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                       
                    });
                });


                $('body').on('click', '#editloanbtn', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_loan', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateLoan').modal('hide');
                                toastr.error('Loan not found.');
                            } else {
                                $('#updateLoan').modal('show');
                                var loan =
                                    response; // response is already the department data
                                $('#loan_id').val(loan.id);
                                // $('#update_employee_id').val(deduction.empoyee_id);
                                $('#update_amount').val(loan.amount);

                                $('#update_reason').val(loan.reason);
                                $('#update_installment').val(loan.installment);
                                $('#update_terms').val(loan.terms);
                                $('#update_date').val(loan.date);
                                $('#update_employee_id').val(loan.employee_id);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Loan.');
                        }
                    });
                });

                $('#updateLoanForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#loan_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateLoanForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_loan_form', ['id' => ':id'])); ?>".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateLoan').modal('hide');
                                $('#loan_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateLoanForm')[0].reset();
                            } else {
                                // Handle non-validation errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            let response = xhr.responseJSON;

                            if (xhr.status === 422 && response.errors) {
                                // Get the first error message from the 'shift' field
                                let firstError = response.errors.loan ? response.errors.loan[0] :
                                    'An error occurred.';
                                toastr.error(firstError); // Show the error message
                            } else if (response && response.message) {
                                toastr.error(response.message);
                            } else {
                                toastr.error('An error occurred while adding the loan.');
                            }
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                $('body').on('click', '#loan_report', function() {
                    var id = $(this).data('id');
                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_loan', ['id' => ':id'])); ?>".replace(':id', id),
                        success: function(response) {
                            if (response.status === 404) {
                                $('#loanReportModal').modal('hide');
                                toastr.error('Loan not found.');
                            } else {
                                $('#loanReportModal').modal('show');

                                var loan = response.report; // Access report data

                                // Format pay date
                                var payDate = new Date(loan.pay_date).toLocaleDateString('en-US', {
                                    year: 'numeric',
                                    month: 'long',
                                    day: 'numeric',
                                    hour: '2-digit',
                                    minute: '2-digit'
                                });

                                // Populate table with loan data
                                var tableRow = `
                  <tr>
                    <td>${payDate}</td>
                    <td>${loan.loan_amount}</td>
                    <td>${loan.paid_amount}</td>
                    <td>${loan.remaining_amount}</td>
                    <td>${loan.remaining_installment}</td>
                  </tr>
                `;

                                // Append row to the table body
                                $('#loanReportTableBody').html(tableRow);
                            }
                        },
                        error: function(xhr) {
                            toastr.error('An error occurred while fetching the Loan.');
                        }
                    });
                });


            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/settings/loan.blade.php ENDPATH**/ ?>