<?php $__env->startSection('content'); ?>
    <style>
        .card {
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
        }

        .info .row {
            margin-top: 15px;
        }

        .tabs {
            left: 50%;
            transform: translateX(-50%);
            position: relative;
            background: white;
            padding: 50px;
            padding-bottom: 80px;
            width: 100%;
            height: auto;
            box-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
            border-radius: 5px;
            min-width: 240px;
        }

        .tabs input[name="tab-control"] {
            display: none;
        }

        .tabs .content section h2,
        .tabs ul li label {
            font-weight: bold;
            font-size: 18px;
            color: #E11c41;
        }

        .tabs ul {
            list-style-type: none;
            padding-left: 0;
            display: flex;
            flex-direction: row;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: flex-end;
            flex-wrap: wrap;
        }

        .tabs ul li {
            box-sizing: border-box;
            flex: 1;
            width: 25%;
            padding: 0 10px;
            text-align: center;
        }

        .tabs ul li label {
            transition: all 0.3s ease-in-out;
            color: #929daf;
            padding: 5px auto;
            overflow: hidden;
            text-overflow: ellipsis;
            display: block;
            cursor: pointer;
            transition: all 0.2s ease-in-out;
            white-space: nowrap;
            -webkit-touch-callout: none;
        }

        .tabs ul li label br {
            display: none;
        }

        .tabs ul li label svg {
            position: relative;
            top: -5px;
            fill: #929daf;
            height: 1.2em;
            vertical-align: bottom;
            margin-right: 0.2em;
            transition: all 0.2s ease-in-out;
        }

        .tabs ul li label:hover,
        .tabs ul li label:focus,
        .tabs ul li label:active {
            outline: 0;
            color: #bec5cf;
        }

        .tabs ul li label:hover svg,
        .tabs ul li label:focus svg,
        .tabs ul li label:active svg {
            fill: #bec5cf;
        }

        .tabs .slider {
            position: relative;
            width: 33%;
            transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
        }

        .tabs .slider .indicator {
            position: relative;
            width: 110px;
            max-width: 100%;
            margin: 0 auto;
            height: 4px;
            background: #E11c41;
            border-radius: 1px;
        }

        .tabs .content {
            margin-top: 30px;
        }

        .tabs .content section {
            display: none;
            animation-name: content;
            animation-direction: normal;
            animation-duration: 0.3s;
            animation-timing-function: ease-in-out;
            animation-iteration-count: 1;
            line-height: 1.4;
        }

        .tabs .content section h2 {
            color: #E11c41;
            display: none;
        }

        .tabs .content section h2::after {
            content: "";
            position: relative;
            display: block;
            width: 30px;
            height: 3px;
            background: #E11c41;
            margin-top: 5px;
            left: 1px;
        }

        .tabs input[name="tab-control"]:nth-of-type(1):checked~ul>li:nth-child(1)>label {
            cursor: default;
            color: #E11c41;
        }

        .tabs input[name="tab-control"]:nth-of-type(1):checked~ul>li:nth-child(1)>label svg {
            fill: #E11c41;
        }

        @media (max-width: 600px) {
            .tabs input[name="tab-control"]:nth-of-type(1):checked~ul>li:nth-child(1)>label {
                background: rgba(0, 0, 0, 0.08);
            }
        }

        .tabs input[name="tab-control"]:nth-of-type(1):checked~.slider {
            transform: translateX(0%);
        }

        .tabs input[name="tab-control"]:nth-of-type(1):checked~.content>section:nth-child(1) {
            display: block;
        }

        .tabs input[name="tab-control"]:nth-of-type(2):checked~ul>li:nth-child(2)>label {
            cursor: default;
            color: #E11c41;
        }

        .tabs input[name="tab-control"]:nth-of-type(2):checked~ul>li:nth-child(2)>label svg {
            fill: #E11c41;
        }

        @media (max-width: 600px) {
            .tabs input[name="tab-control"]:nth-of-type(2):checked~ul>li:nth-child(2)>label {
                background: rgba(0, 0, 0, 0.08);
            }
        }

        .tabs input[name="tab-control"]:nth-of-type(2):checked~.slider {
            transform: translateX(100%);
        }

        .tabs input[name="tab-control"]:nth-of-type(2):checked~.content>section:nth-child(2) {
            display: block;
        }

        .tabs input[name="tab-control"]:nth-of-type(3):checked~ul>li:nth-child(3)>label {
            cursor: default;
            color: #E11c41;
        }

        .tabs input[name="tab-control"]:nth-of-type(3):checked~ul>li:nth-child(3)>label svg {
            fill: #E11c41;
        }

        @media (max-width: 600px) {
            .tabs input[name="tab-control"]:nth-of-type(3):checked~ul>li:nth-child(3)>label {
                background: rgba(0, 0, 0, 0.08);
            }
        }

        .tabs input[name="tab-control"]:nth-of-type(3):checked~.slider {
            transform: translateX(200%);
        }

        .tabs input[name="tab-control"]:nth-of-type(3):checked~.content>section:nth-child(3) {
            display: block;
        }

        .tabs input[name="tab-control"]:nth-of-type(4):checked~ul>li:nth-child(4)>label {
            cursor: default;
            color: #E11c41;
        }

        .tabs input[name="tab-control"]:nth-of-type(4):checked~ul>li:nth-child(4)>label svg {
            fill: #E11c41;
        }

        @media (max-width: 600px) {
            .tabs input[name="tab-control"]:nth-of-type(4):checked~ul>li:nth-child(4)>label {
                background: rgba(0, 0, 0, 0.08);
            }
        }

        .tabs input[name="tab-control"]:nth-of-type(4):checked~.slider {
            transform: translateX(300%);
        }

        .tabs input[name="tab-control"]:nth-of-type(4):checked~.content>section:nth-child(4) {
            display: block;
        }

        @keyframes content {
            from {
                opacity: 0;
                transform: translateY(5%);
            }

            to {
                opacity: 1;
                transform: translateY(0%);
            }
        }

        @media (max-width: 1000px) {
            .tabs ul li label {
                white-space: initial;
            }

            .tabs ul li label br {
                display: initial;
            }

            .tabs ul li label svg {
                height: 1.5em;
            }
        }

        @media (max-width: 800px) {
            .tabs ul li label {
                padding: 5px;
                border-radius: 5px;
            }

            .tabs ul li label span {
                display: none;
            }

            .tabs .slider {
                display: none;
            }

            .tabs .content {
                margin-top: 20px;
            }

            .tabs .content section h2 {
                display: block;
            }
        }
    </style>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Profile
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <a href="<?php echo e(url('/')); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-arrow-left mr-sm-2"></i>Back</a>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Profile
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="row gutters-sm">
                <div class="col-md-4 mb-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center text-center">
                                <?php
                                    $baseUrl = env('API_URL_FOR_IMAGE');
                                ?>

                                <?php if(isset($employee['user_profile']['image'])): ?>
                                    <img src="<?php echo e($baseUrl . '/' . $employee['user_profile']['image']); ?>"
                                        alt="Employee Image" class="rounded-circle" style="width: 200px;height: 195px;" >
                                <?php else: ?>
                                    <img src="<?php echo e(asset('default-image.jpg')); ?>" alt="Default Image" class="rounded-circle"
                                    style="width: 200px;height: 195px;"    >
                                <?php endif; ?>

                                <div class="mt-3">
                                    <p class="text-uppercase font-weight-bold">
                                        Employee
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body info">
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Full Name :</h6>
                                </div>
                                <div class="col-sm-9 text-black">
                                    <?php echo e($employee['user_profile']['user']['name'] ?? 'N/A'); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Email :</h6>
                                </div>
                                <div class="col-sm-9 text-black">
                                   <span><?php echo e($employee['user_profile']['user']['email'] ?? 'N/A'); ?></span> 
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Phone :</h6>
                                </div>
                                <div class="col-sm-9 text-black">
                                    <?php echo e($employee['user_profile']['phone'] ?? 'N/A'); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Department :</h6>
                                </div>
                                <div class="col-sm-9 text-uppercase text-black">
                                    <span class="text-capitalize"> <?php echo e($employee['department']['department'] ?? 'N/A'); ?></span>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Designation :</h6>
                                </div>
                                <div class="col-sm-9 text-uppercase text-black">
                                    <span class="text-capitalize"><?php echo e($employee['designation']['designation'] ?? 'N/A'); ?></span>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="font-weight-bold mb-0">Gender :</h6>
                                </div>
                                <div class="col-sm-9 text-uppercase text-black">
                                    <span class="text-capitalize"><?php echo e($employee['user_profile']['gender'] ?? 'N/A'); ?></span>
                                </div>
                            </div>

                            <hr>

                        </div>
                    </div>
                </div>
            </div>

            <div class="tabs mt-3">

                <input type="radio" id="tab1" name="tab-control" checked>
                <input type="radio" id="tab2" name="tab-control">
                <input type="radio" id="tab3" name="tab-control">
                <ul>
                    <li title="Education">
                        <label for="tab1" role="button">
                            <svg version="1.1" id="education_x5F_icons_1_" xmlns="http://www.w3.org/2000/svg" x="0" y="0"
                                viewBox="0 0 128 128" style="enable-background:new 0 0 128 128" xml:space="preserve">
                                <style>
                                    .st0 {
                                        display: none
                                    }

                                    .st1 {
                                        display: inline
                                    }

                                    .st3 {
                                        display: inline;
                                        fill-rule: evenodd;
                                        clip-rule: evenodd
                                    }
                                </style>
                                <g id="row2_1_">
                                    <g id="certificate_1_">
                                        <g id="icon_10_">
                                            <path class="st2"
                                                d="M33.4 27.8v2.8H64v-2.8H33.4zm0 27.9v2.8h61.2v-2.8H33.4zm0 16.6v2.8h61.2v-2.8H33.4zm0 8.4v2.8h61.2v-2.8H33.4zM108.5 0h-89c-1.5 0-2.8 1.2-2.8 2.8v105.7c0 1.5 1.2 2.8 2.8 2.8H64v-5.6H22.3V5.6h83.5v100.2H103v5.6h5.6c1.5 0 2.8-1.2 2.8-2.8V2.8c-.1-1.6-1.3-2.8-2.9-2.8zM33.4 39v2.8h61.2V39H33.4zm0 25v2.8h61.2V64H33.4zm0-16.7v2.8h61.2v-2.8H33.4zm0-27.8v2.8H64v-2.8H33.4z" />
                                            <path class="st2"
                                                d="M95.2 109.6c1.6-2.1 2.6-4.8 2.6-7.7C97.8 94.8 92 89 84.9 89 77.7 89 72 94.8 72 101.9c0 2.9 1 5.6 2.6 7.7L66.8 128c.3-.3 2.7-2.7 5.5-2.7 2.5 0 5.6 2.8 5.6 2.8l6.9-13.3 7 13.3s2.4-2.8 5.6-2.8c2.3 0 5.6 2.8 5.6 2.8l-7.8-18.5zm-16.1-10c-1.7-1.9-1.4-4.9.5-6.6 1.9-1.7 4.8-1.5 6.4.5 1.6 1.9-3.7 1.2-5.6 2.9-1.9 1.6.3 5.1-1.3 3.2zm4.7 10.1c-1.6-1.9 3.7-1.2 5.6-2.9 1.9-1.7-.3-5.2 1.3-3.2 1.7 1.9 1.4 4.9-.5 6.6-1.9 1.6-4.8 1.4-6.4-.5z" />
                                        </g>
                                    </g>
                                </g>
                            </svg>
                            <span>Education</span>
                        </label>
                    </li>

                    <li title="Work Experience">
                        <label for="tab2" role="button">
                            <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 209.1137 203.2151"
                                enable-background="new 0 0 209.1137 203.2151" xml:space="preserve">
                                <g>
                                    <circle cx="84.197" cy="22.5" r="22.5" />
                                    <path d="M50.892,136.2058c1.0385,0.335,2.1381,0.5273,3.2756,0.5781c1.9249,0.2257,3.8539,0.2775,5.7067,0.2538
                                                        c1.6762-0.0211,3.1807-0.0723,4.5181-0.2254h29.4305l14.8813,57.0547c1.4663,5.6226,6.5352,9.3481,12.0869,9.3481
                                                        c1.0439,0,2.1055-0.1318,3.1631-0.4077c6.6802-1.7422,10.6831-8.5698,8.9404-15.25l-17.3189-66.3999
                                                        c-1.4355-5.5044-6.4067-9.3452-12.0952-9.3452h-31.777c0.0386-6.4716,0.774-13.09,1.7744-19.444L55.0078,71.9187
                                                        c-1.8438-2.0415-2.7832-4.6792-2.6426-7.4272c0.1396-2.7476,1.3408-5.2764,3.3818-7.1201
                                                        c1.8975-1.7129,4.3477-2.6563,6.9023-2.6563c2.9102,0,5.6963,1.2378,7.6455,3.396l25.5615,28.3013h29.6974l7.8793-1.9296
                                                        c4.2915-1.0513,6.9185-5.3818,5.8677-9.6733s-5.3799-6.916-9.6733-5.8677l-32.0669,7.853L74.0123,50.2752
                                                        c-0.3891-0.438-0.8174-0.8193-1.272-1.1512c-1.3181-1.1301-2.8424-1.9636-4.5652-2.3929
                                                        c-8.5371-2.129-20.9121,2.5078-25.9473,17.1503c-6.8047,20.1739-8.2676,33.3047-5.6816,55.5196
                                                        C38.6815,130.3898,44.4997,134.6464,50.892,136.2058z" />
                                    <polygon
                                        points="119.1137,117.7955 172.7803,117.7955 172.7803,192.1288 137.6137,192.1288 137.6137,200.7955 209.1137,200.7955
                                209.1137,192.1288 188.2803,192.1288 188.2803,117.7955 209.1137,117.7955 209.1137,109.1288 119.1137,109.1288 	" />
                                    <path
                                        d="M21.2312,146.9364c1.9556,4.2899,12.3113,7.7261,25.6608,8.606v1.77h4.2502v21.0536l-29.25,8.9995v3.6837
                                                        c-1.8742,0.9243-3.1668,2.8486-3.1668,5.0797c0,3.1296,2.537,5.6667,5.6666,5.6667c3.1296,0,5.6667-2.5371,5.6667-5.6667
                                                        c0-2.2262-1.2868-4.147-3.1544-5.0737l24.2379-7.4578v7.4518c-1.8742,0.9243-3.1668,2.8486-3.1668,5.0797
                                                        c0,3.1296,2.537,5.6667,5.6666,5.6667c3.1296,0,5.6667-2.5371,5.6667-5.6667c0-2.231-1.2924-4.1552-3.1665-5.0795v-7.452
                                                        l24.2377,7.4578c-1.8676,0.9266-3.1545,2.8475-3.1545,5.0737c0,3.1296,2.537,5.6667,5.6666,5.6667
                                                        c3.1296,0,5.6667-2.5371,5.6667-5.6667c0-2.231-1.2924-4.1552-3.1665-5.0795v-3.6838l-29.25-8.9995v-21.0536h4.2498v-1.77
                                                        c14.8483-0.9787,26-5.1194,26-10.0803c0-4.8072-46.77-5.5518-61.2662-2.2345l-11.2109-29.8563
                                                        c4.7803,7.4583,9.7065,11.6874,13.0239,10.4418c5.3257-1.9998-17.6995-63.3194-23.0251-61.3196
                                                        c-4.3408,1.6299-4.5862,12.1283-1.0861,25.1241c-0.3952-0.0529-0.8066-0.0233-1.2059,0.1267
                                                        c-1.2925,0.4854-1.9468,1.9268-1.4614,3.2192l20.8574,55.5464C21.0749,146.6625,21.1492,146.8026,21.2312,146.9364z" />
                                    <path d="M140.9215,104.7122h35.2006c1.0928,0,2.0986-0.5942,2.627-1.5508l24.917-45.1665l-5.2539-2.8984l-24.0615,43.6157h-29.8019
                                                        C144.0732,101.1177,142.7581,103.223,140.9215,104.7122z" />
                                    <path
                                        d="M68.5879,59.6526c-2.96-3.2778-8.0195-3.5356-11.2988-0.5747c-3.2783,2.9614-3.5361,8.0205-0.5742,11.2993l28.6289,31.6973
                                                        c1.5166,1.6792,3.6738,2.6377,5.9365,2.6377h38.5088h4.6582c4.418,0,8-3.5815,8-8s-3.582-8-8-8H94.835L68.5879,59.6526z" />
                                </g>
                            </svg>

                            <span>Experience</span>
                        </label>
                    </li>

                    <li title="Security">
                        <label for="tab3" role="button">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64">
                                <g data-name="Credi Card">
                                    <path
                                        d="M61 34h-2v-2a6 6 0 0 0-12 0v2h-2a3.003 3.003 0 0 0-3 3v14a3.003 3.003 0 0 0 3 3h16a3.003 3.003 0 0 0 3-3V37a3.003 3.003 0 0 0-3-3zm-12-2a4 4 0 0 1 8 0v2h-8zm13 19a1 1 0 0 1-1 1H45a1 1 0 0 1-1-1V37a1 1 0 0 1 1-1h16a1 1 0 0 1 1 1z" />
                                    <path
                                        d="M53 39a2.993 2.993 0 0 0-1 5.816V48a1 1 0 0 0 2 0v-3.184A2.993 2.993 0 0 0 53 39zm0 4a1 1 0 1 1 1-1 1 1 0 0 1-1 1zM39 40H3a1.001 1.001 0 0 1-1-1V22h50v1a1 1 0 0 0 2 0V13a3.003 3.003 0 0 0-3-3H3a3.003 3.003 0 0 0-3 3v26a3.003 3.003 0 0 0 3 3h36a1 1 0 0 0 0-2zM2 20v-3h50v3zm1-8h48a1 1 0 0 1 1 1v2H2v-2a1.001 1.001 0 0 1 1-1z" />
                                    <path
                                        d="M5 36a1 1 0 0 0 0 2h13a1 1 0 0 0 0-2zM23 36h-2a1 1 0 0 0 0 2h2a1 1 0 0 0 0-2zM23 32H5a1 1 0 0 0 0 2h18a1 1 0 0 0 0-2z" />
                                </g>
                            </svg>
                            <span>Security</span>
                        </label>
                    </li>


                </ul>

                <div class="slider">
                    <div class="indicator"></div>
                </div>
                <hr style="width:100%;">

                <div class="content">

                    <section class="Education">
                        <h2>Education</h2>
                        <div class="row">
                            <div class="col-md-6 mb-2" style="border-right: 2px solid #E11c41">
                                <div class="row">
                                    <div class="col-md-4">
                                        <strong>Institute Name : </strong>
                                    </div>

                                    <div class="col-md-8">
                                        <p> <?php echo e($employee['education']['institute_name'] ?? 'N/A'); ?> </p>
                                    </div>

                                    <div class="col-md-4">
                                        <strong>Last Degree : </strong>
                                    </div>

                                    <div class="col-md-8">
                                        <p> <?php echo e($employee['education']['last_degree'] ?? 'N/A'); ?> </p>
                                    </div>

                                    <div class="col-md-4">
                                        <strong>Campus </strong>
                                    </div>

                                    <div class="col-md-8">
                                        <p><?php echo e($employee['education']['campus'] ?? 'N/A'); ?> </p>
                                    </div>

                                    <div class="col-md-4">
                                        <strong>Session Start : </strong>
                                    </div>
                                    <div class="col-md-8">
                                        <p><?php echo e($employee['education']['session_start'] ?? 'N/A'); ?> </p>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>Session End : </strong>
                                    </div>
                                    <div class="col-md-8">
                                        <p><?php echo e($employee['education']['session_end'] ?? 'N/A'); ?> </p>
                                    </div>

                                    <div class="col-md-4">
                                        <strong>Attached File: </strong>

                                    </div>

                                    <div class="col-md-8">

                                        <?php if(isset($employee['education']['attach_file'])): ?>
                                            <img src="<?php echo e($employee['education']['attach_file']); ?>" alt="Employee Image"
                                                 style="width: 100%; max-width: 250px;">
                                        <?php else: ?>
                                            <p> N/A</p>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php if(isset($employee['education'])): ?>
                                    <form action="<?php echo e(route('update_education_form', $employee['education']['id'])); ?>"
                                        method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>

                                        <div class="row">
                                            <div class="col-md-6 mt-2">
                                                <label for="institute_name">Institute Name:</label>
                                                <input type="text" id="institute_name" name="institute_name"
                                                    class="form-control form-control-sm" placeholder="Institute Name"
                                                    value="<?php echo e(old('institute_name', $employee['education']['institute_name'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['institute_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="last_degree">Last Degree:</label>
                                                <input type="text" id="last_degree" name="last_degree"
                                                    class="form-control form-control-sm" placeholder="Last Degree"
                                                    value="<?php echo e(old('last_degree', $employee['education']['last_degree'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['last_degree'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="campus">Campus:</label>
                                                <input type="text" id="campus" name="campus"
                                                    class="form-control form-control-sm" placeholder="Campus"
                                                    value="<?php echo e(old('campus', $employee['education']['campus'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['campus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="session_start">Session Start:</label>
                                                <input type="date" id="session_start" name="session_start"
                                                    class="form-control form-control-sm" placeholder="Session Start"
                                                    value="<?php echo e(old('session_start', $employee['education']['session_start'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['session_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="session_end">Session End:</label>
                                                <input type="date" id="session_end" name="session_end"
                                                    class="form-control form-control-sm" placeholder="Session End"
                                                    value="<?php echo e(old('session_end', $employee['education']['session_end'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['session_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-12 mt-2">
                                                <label for="attach_file">Attach File:</label>
                                                <input type="file" id="attach_file"
                                                    data-allowed-file-extensions="png jpg svg gif jpeg"
                                                    class="form-control" name="attach_file">
                                                <small id="emailHelp" class="form-text text-muted">(File must be a type of png,jpg,jpeg) </small>
                                                <?php $__errorArgs = ['attach_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit"
                                                    class="btn btn-sm btn-danger float-right mt-2">Update
                                                    Education</button>
                                            </div>
                                        </div>
                                    </form>
                                <?php else: ?>
                                    <form action="<?php echo e(route('add_education_form')); ?>" method="POST"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-6 mt-2">
                                                <label for="institute_name">Institute Name:</label>
                                                <input type="text" id="institute_name" name="institute_name"
                                                    class="form-control form-control-sm" placeholder="Institute Name"
                                                    required>
                                                <?php $__errorArgs = ['institute_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="last_degree">Last Degree:</label>
                                                <input type="text" id="last_degree" name="last_degree"
                                                    class="form-control form-control-sm" placeholder="Last Degree"
                                                    required>
                                                <?php $__errorArgs = ['last_degree'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="campus">Campus:</label>
                                                <input type="text" id="campus" name="campus"
                                                    class="form-control form-control-sm" placeholder="Campus" required>
                                                <?php $__errorArgs = ['campus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="session_start">Session Start:</label>
                                                <input type="date" id="session_start" name="session_start"
                                                    class="form-control form-control-sm" required>
                                                <?php $__errorArgs = ['session_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="session_end">Session End:</label>
                                                <input type="date" id="session_end" name="session_end"
                                                    class="form-control form-control-sm" required>
                                                <?php $__errorArgs = ['session_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-12 mt-2">
                                                <label for="attach_file">Attach File:</label>
                                                <input type="file" id="attach_file" name="attach_file"
                                                    class="form-control"
                                                    data-allowed-file-extensions="png jpg svg gif jpeg">
                                                <small id="emailHelp" class="form-text text-muted">(File must be a type of png,jpg,jpeg) </small>
                                                <?php $__errorArgs = ['attach_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="btn btn-sm btn-danger float-right mt-2">Add
                                                    Education</button>
                                            </div>
                                        </div>
                                    </form>

                                <?php endif; ?>


                        </div>
                    </div>
                </section>

                <section class="Experience">
                    <h2>Work Experience</h2>
                    <div class="row">
                        <div class="col-md-6 mb-2" style="border-right: 2px solid #E11c41">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>Company Name : </strong>
                                </div>

                                <div class="col-md-8">
                                    <p> <?php echo e($employee['work_history']['company_name'] ?? 'N/A'); ?> </p>
                                </div>

                                <div class="col-md-4">
                                    <strong>Designation : </strong>
                                </div>

                                <div class="col-md-8">
                                    <p> <?php echo e($employee['work_history']['designation'] ?? 'N/A'); ?> </p>
                                </div>


                                <div class="col-md-4">
                                    <strong>Joining Date : </strong>
                                </div>

                                <div class="col-md-8">
                                    <p> <?php echo e($employee['work_history']['joining_date'] ?? 'N/A'); ?> </p>
                                </div>
                                <div class="col-md-4">
                                    <strong>Leaving Date : </strong>
                                </div>

                                <div class="col-md-8">
                                    <p> <?php echo e($employee['work_history']['leaving_date'] ?? 'N/A'); ?> </p>
                                </div>

                                <div class="col-md-4">
                                    <strong>Reason: </strong>
                                </div>

                                <div class="col-md-8">
                                    <p> <?php echo e($employee['work_history']['reason'] ?? 'N/A'); ?> </p>
                                </div>

                            </div>
                        </div>
                        <div class="col-md-6 ms-2">
                            <div class="row" style="margin-left: 7px;">
                                <?php if(isset($employee['work_history'])): ?>
                                    <form action="<?php echo e(route('update_work_history', $employee['work_history']['id'])); ?>"
                                        method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?> 
                                        <div class="row">
                                            <div class="col-md-6 mt-2">
                                                <label for="company_name">Company Name:</label>
                                                <input type="text" id="company_name" name="company_name"
                                                    class="form-control form-control-sm"
                                                    value="<?php echo e(old('company_name', $employee['work_history']['company_name'])); ?>"
                                                    placeholder="Company Name" required>
                                                <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="designation">Designation:</label>
                                                <input type="text" id="designation" name="designation"
                                                    class="form-control form-control-sm"
                                                    value="<?php echo e(old('designation', $employee['work_history']['designation'])); ?>"
                                                    placeholder="Designation" required>
                                                <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="joining_date">Joining Date:</label>
                                                <input type="date" id="joining_date" name="joining_date"
                                                    class="form-control form-control-sm"
                                                    value="<?php echo e(old('joining_date', $employee['work_history']['joining_date'])); ?>"
                                                    placeholder="Joining Date" required>
                                                <?php $__errorArgs = ['joining_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="leaving_date">Leaving Date:</label>
                                                <input type="date" id="leaving_date" name="leaving_date"
                                                    class="form-control form-control-sm"
                                                    value="<?php echo e(old('leaving_date', $employee['work_history']['leaving_date'])); ?>"
                                                    required>
                                                <?php $__errorArgs = ['leaving_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-12 mt-2">
                                                <label for="reason">Reason:</label>
                                                <textarea class="form-control" id="summernote" rows="6" name="reason" required><?php echo e(old('reason', $employee['work_history']['reason'])); ?></textarea>
                                                <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit"
                                                    class="btn btn-sm btn-danger float-right mt-2">Update Work
                                                    History</button> <!-- Changed button text -->
                                            </div>
                                        </div>
                                    </form>
                                <?php else: ?>
                                    <form action="<?php echo e(route('add_work_history')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-6 mt-2">
                                                <label for="company_name">Company Name:</label>
                                                <input type="text" id="company_name" name="company_name"
                                                    class="form-control form-control-sm" placeholder="Company Name"
                                                    required>
                                                <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="designation"> Designation:</label>
                                                <input type="text" id="designation" name="designation"
                                                    class="form-control form-control-sm" placeholder=" Designation"
                                                    required>
                                                <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="joining_date">Joining Date:</label>
                                                <input type="date" id="joining_date" name="joining_date"
                                                    class="form-control form-control-sm" placeholder="Joining Date"
                                                    required>
                                                <?php $__errorArgs = ['joining_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mt-2">
                                                <label for="leaving_date">Leaving Date:</label>
                                                <input type="date" id="leaving_date" name="leaving_date"
                                                    class="form-control form-control-sm" required>
                                                <?php $__errorArgs = ['leaving_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>


                                            <div class="col-md-12 mt-2">
                                                <label for="attach_file">Reason</label>
                                                <textarea class="form-control" name="reason" id="reason" rows="6" ></textarea>
                                                <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit"
                                                    class="btn btn-sm btn-danger float-right mt-2">Add Work
                                                    History</button>
                                            </div>
                                        </div>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="Security">
                    <h2>Security</h2>
                    <div class="row">
                        <div class="col-md-6" style="border-right: 2px solid #E11c41">
                            <div class="mb-2 text-center">
                                <img src="<?php echo e(asset('assets/images/password.jpg')); ?>" alt=""
                                    style="width: 100%; max-width:400px; height:auto;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <form id="update_password" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <h4 class="ml-2">Update Password</h4>
                                    <input type="hidden" value="<?php echo e(session('id')); ?>" name="user_id"
                                        id="user_id">
                                    <div class="col-md-12 mt-3">
                                        <input type="password" name="password" id="password"
                                            class="form-control form-control-sm text-danger"
                                            placeholder="Create New Password">

                                    </div>
                                    <div class="col-md-12 mt-3">
                                        <input type="password" name="password_confirmation"
                                            id="password_confirmation"
                                            class="form-control form-control-sm text-danger"
                                            placeholder="Retype Password">

                                    </div>
                                    <div class="col-12 mt-3 text-right">
                                        <button type="submit" class="btn btn-sm btn-danger">Update Password</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-sm-left d-block d-sm-inline-block text-center">Copyright © 2023.
                All rights reserved.</span>
            <span class="float-sm-right d-block mt-sm-0 float-none mt-1 text-center">Hand-crafted & made
                with <i class="far fa-heart text-danger"></i></span>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
        integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $('.dropify').dropify();
    </script>

    <script>
        $('#update_password').on('submit', function(e) {
            e.preventDefault();

            // Retrieve user ID from hidden input
            var id = $('#user_id').val();

            // Serialize form data
            var formData = $(this).serialize();
            let $submitButton = $(this).find('button[type="submit"]');

            $submitButton.prop('disabled', true); // Disable the button during submission

            $.ajax({
                url: "<?php echo e(route('update_profile_password_form', ['id' => ':id'])); ?>"
                    .replace(':id', id),
                type: 'PUT',
                data: formData,
                success: function(response) {
                    if (response.success) {
                        toastr.success(response
                            .message);
                        $('#update_password')[0].reset();
                    } else {
                        toastr.error(response.message); // Show error message
                    }
                    $submitButton.prop('disabled',
                        false); // Re-enable the button
                },
                error: function(xhr) {
                    $submitButton.prop('disabled',
                        false); // Re-enable the button in case of error
                    if (xhr.status === 422) {
                        // Handle validation errors
                        var errors = xhr.responseJSON.errors;
                        // Show the first validation error
                        if (errors.password) {
                            toastr.error(errors.password[
                                0]); // Show first validation error
                        }
                    } else {
                        toastr.error(
                            'Something went wrong, please try again.'); // General error
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/profile/employee_profile.blade.php ENDPATH**/ ?>