<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title>Hexon Digital HRM</title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/iconfonts/font-awesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/css/vendor.bundle.base.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/css/vendor.bundle.addons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/iconfonts/simple-line-icon/css/simple-line-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <!-- endinject -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo-mini.png')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote-lite.css">
    <link href="<?php echo e(url('/assets/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" >
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" />
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
</head>
<body>
  
<div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
        <div class="content-wrapper d-flex align-items-stretch auth auth-img-bg" style="margin-top: 0;">
            <div class="row flex-grow">
                <div class="col-lg-6 d-flex align-items-center justify-content-center"
                    style="background-color: #fff;">
                    <div class="auth-form-transparent text-left p-3">
                        <div class="brand-logo">
                            <img src="<?php echo e(asset('assets/images/logo-beta.png')); ?>" alt="logo">
                        </div>

                        <h4>Welcome back!</h4>

                        <h6 class="font-weight-light result text-danger"></h6>

                        <form class="pt-3" action="<?php echo e(route('login')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="exampleInputEmail">Email</label>
                                <div class="input-group">
                                    <div class="input-group-prepend bg-transparent">
                                        <span class="input-group-text bg-transparent border-right-0">
                                            <i class="fa fa-user text-primary"></i>
                                        </span>
                                    </div>
                                    <input type="email" class="form-control form-control-lg border-left-0"
                                        name="email" placeholder="Email ... " required>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputPassword">Password</label>
                                <div class="input-group">
                                    <div class="input-group-prepend bg-transparent">
                                        <span class="input-group-text bg-transparent border-right-0">
                                            <i class="fa fa-lock text-primary"></i>
                                        </span>
                                    </div>
                                    <input type="password" class="form-control form-control-lg border-left-0"
                                        name="password" placeholder="Password ..." required>
                                </div>
                            </div>

                            <div class="my-2 d-flex justify-content-between align-items-center">
                                <div class="form-check">
                                    <label class="form-check-label text-muted">
                                        <input type="checkbox" class="form-check-input">
                                        Keep me signed in
                                    </label>
                                </div>
                                <a href="" class="auth-link text-black">Forgot password?</a>
                            </div>
                            <div class="my-3">
                                <button type="submit"
                                    class="btn btn-block btn-primary btn-lg font-weight-medium ">LOGIN</button>
                            </div>
                        </form>
                        
                    </div>
                </div>
                <div class="col-lg-6 login-half-bg d-flex text-center flex-row">
                    <div class="col-12 text-center">
                        <h1 class="text-white"><span class="text-danger">Way </span> to <span class="text-danger">Digital</span>.</h1>
                    </div>
                    <p class="text-white font-weight-medium text-center flex-grow align-self-end">Copyright &copy;
                        2023 All rights reserved.</p>
                </div>
            </div>
        </div>
        <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
</div>



<script>
    const images = [
        '<?php echo e(asset('assets/images/auth/form.jfif')); ?>',
        '<?php echo e(asset('assets/images/auth/login-bg.jpg')); ?>',
        '<?php echo e(asset('assets/images/auth/register-bg.jpg')); ?>',
        '<?php echo e(asset('assets/images/auth/lockscreen-bg.jpg')); ?>',
    ];

    let currentIndex = 0;
    function changeBackgroundImage() {
        $('.login-half-bg').css('background-image', `url(${images[currentIndex]})`);
        currentIndex = (currentIndex + 1) % images.length;
    }

    changeBackgroundImage();
    setInterval(changeBackgroundImage, 5000);
</script>

<?php echo $__env->make('admin.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/auth/login.blade.php ENDPATH**/ ?>