<?php

namespace App\Http\Controllers\Settings;

use App\DataTables\Settings\BonusDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class BonusController extends Controller
{
    private function fetch_employees(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        
        $response = Http::withToken($token)->get("{$apiBaseUrl}/employees");
    
        if ($response->successful()) {
            // Fetch the employee data including related user name
            $employees = $response->json()['employees'] ?? [];
            
            // Extract only the employee ID and the associated user name
            $employees = array_map(function ($employee) {
                return [
                    'id' => $employee['id'], // Employee ID
                    'name' => $employee['user_profile']['user']['name'] ?? null, // Associated User's Name
                ];
            }, $employees);
    
            return $employees;
        }
    
        return [];
    }
    
    public function bonus_list(BonusDataTable $dataTable)
    {
        $employees = $this->fetch_employees();
        return $dataTable->render('admin.settings.bonus',compact('employees'));
    }
    public function add_bonus_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/bonuses/store", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => $request->status,
                'org_id' => $org_id
            ]);
          
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Bonus added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Bonus.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_bonus_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the education
            $response = Http::withToken($token)->put("{$apiBaseUrl}/bonuses/update/{$id}", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => $request->status,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Bonus updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Bonus.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_bonus($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/bonuses/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Bonus deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Bonus'
            ], $response->status());
        }
    }

    public function get_bonus($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            // Make the GET request to the external API
            $response = Http::withToken($token)->get("{$apiBaseUrl}/bonuses/get/{$id}");
            
            if ($response->successful()) {
                // Get the bonus data (assuming only one bonus is retrieved for a given id)
                $bonusData = $response->json()['bonus'];
                return response()->json($bonusData);
            } else {
                return response()->json(['status' => 404, 'message' => 'Bonus not found.'], 404);
            }
        } catch (\Exception $e) {
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
