<?php

namespace App\Http\Controllers\Settings;

use App\DataTables\Settings\TaxSlabDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;


class TaxSlabController extends Controller
{
    public function tax_slab_list(TaxSlabDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.tax_slab');
    }
    public function add_tax_slab_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/tax/slabs/store", [
                'tax_slab' => $request->tax_slab,
                'status' => $request->status,
                'tax' => $request->tax,
                'org_id' => $org_id
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Tax Slab added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Tax Slab.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_tax_slab_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the department
            $response = Http::withToken($token)->put("{$apiBaseUrl}/tax/slabs/update/{$id}", [
               'tax_slab' => $request->tax_slab,
                'status' => $request->status,
                'tax' => $request->tax,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Tax Slab updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Tax Slab.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_tax_slab($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/tax/slabs/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Tax Slab deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Tax Slab'
            ], $response->status());
        }
    }

    public function get_tax_slab($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/tax/slabs/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the department data from the API response
                return response()->json($response->json()['tax_slab']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Tax Slab not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
