@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Employee List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <a href="{{ route('create_employee') }}" data-bs-toggle="modal" id="add_user"
                        class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Employee
                    </a>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Employee List</li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="employee_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Image</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Department</th>
                                            <th>Designation</th>
                                            <th>Phone</th>
                                            <th>Address</th>
                                            <th>Salery Slip</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for selecting month -->
    <div class="modal fade" id="salarySlipModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Generate Salary Slip</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('fetchPayslip') }}" method="GET">
                   
                            <input type="hidden" name="employee_id" id="employee_id" class="form-control" required>
        
    
                        <div class="form-group">
                            <label for="month">Month:</label>
                            <input type="month" name="month" id="month" class="form-control" required>
                        </div>
    
                        <button type="submit" class="btn btn-primary">Generate Salary Slip</button>
                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            $('#employee_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('employee_list') }}',
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'image',
                        name: 'image',

                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'department',
                        name: 'department'
                    },
                    {
                        data: 'designation',
                        name: 'designation'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'address',
                        name: 'address'
                    },
                    {
                        data: null,
                        name: 'Salery Slip',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                     <a role="button" data-id="${row.id}" class="btn btn-warning salarySlipBtn">Salary Slip</a>  `;
                        }
                    },
                    {
                        data: null,
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                    <div class="dropdown">
                        <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            ⋮
                        </a>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <button data-id="${row.id}" id="editallowtbtn" class="dropdown-item text-primary">
                                <i class="fa fa-pen mr-2"></i> Edit
                            </button>
                            <button data-id="${row.id}" id="delete_employee" class="dropdown-item text-danger">
                                <i class="far fa-trash-alt mr-2"></i> Delete
                            </button>
                        </div>
                    </div>
                `;
                        }
                    }
                ]
            });


            $('body').on('click', '#delete_employee', function() {
                var id = $(this).data('id');

                $.ajax({
                    type: "DELETE",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('delete_employee', ['id' => ':id']) }}"
                        .replace(':id', id),
                    success: function(response) {
                        $('#employee_table').DataTable().ajax.reload();
                        // Show success Toastr message
                        toastr.success('Employee deleted successfully');
                    },
                    error: function(xhr) {
                        // Display error Toastr message
                        let errorMessage = 'An error occurred while deleting the Employee.';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        toastr.error(errorMessage);
                    }
                });
            });

            var employeeId;

            // Show modal and set employee ID
            $('#employee_table').on('click', '.salarySlipBtn', function() {
                employeeId = $(this).data('id');
                $('#employee_id').val(employeeId);
                $('#salarySlipModal').modal('show');
            });


        });
    </script>
@endpush
