

<?php $__env->startSection('content'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Organization List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_organization" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Organization</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Organization List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="organization_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User </th>
                                            <th>Name</th>
                                            <th>Permissions</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="createOrganization" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Organization</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addOrganizationForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label for="">Name</label>
                        <input class="form-control" id="name" name="name" placeholder="Enter name" required>

                        <label for="permissions" class="mt-4">Permissions</label>
                        <select name="permissions[]" id="permissions" class="form-control select2" multiple required>
                            <option value="employee">Employee</option>
                            <option value="finance">Finance</option>
                            <option value="settings">Settings</option>
                            <option value="users">Users</option>
                        </select>

                        <label class="mt-4">Status</label>
                        <select class="form-control" id="status" name="status" required>
                            <option disabled selected>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>

                        <label class="mt-4">User</label>
                        <select class="form-control" id="user_id" name="user_id" required>
                            <option disabled selected>Select User</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user['id']); ?>"><?php echo e($user['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateOrganization" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Designation</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateOrganizationForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <?php echo csrf_field(); ?>
                        <label for="">Name</label>
                        <input class="form-control" id="update_name" name="name" placeholder="Enter name" required>

                        <input type="hidden" name="organization_id" id="organization_id">
                        <label for="permissions" class="mt-4">Permissions</label>
                        <select name="permissions[]" id="update_permissions" class="form-control select2" multiple required>
                            <option value="employee">Employee</option>
                            <option value="finance">Finance</option>
                            <option value="settings">Settings</option>
                            <option value="users">Users</option>
                        </select>

                        <label class="mt-4">Status</label>
                        <select class="form-control" id="update_status" name="status" required>
                            <option disabled selected>Select Status</option>
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>

                        <label class="mt-4">User</label>
                        <select class="form-control" id="update_user_id" name="user_id" required>
                            <option disabled selected>Select User</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user['id']); ?>"><?php echo e($user['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
      
   
        <script>
           $(".select2").select2({
                width: '100%',
            });
        </script>
        <script>
            $(document).ready(function() {
                $('#organization_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo e(route('organization_list')); ?>',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'user_id',
                            name: 'user_id'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'permissions',
                            name: 'permissions'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },

                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editOrganizationbtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_organization"  class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#add_organization').on('click', function() {
                    $('#createOrganization').modal('show');
                });
                $('#addOrganizationForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addOrganizationForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('add_organization_form')); ?>",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createOrganization').modal('hide');
                                $('#organization_table').DataTable().ajax.reload();
                                $('#addOrganizationForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Organization is Already Added'); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });
                $('body').on('click', '#delete_organization', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('delete_organization', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {
                            $('#organization_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Organization deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Organization.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editOrganizationbtn', function() {
                    var id = $(this).data('id');

                    console.log('Organization ID:', id); // Log the ID to check if it's correct

                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('get_organization', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateOrganization').modal('hide');
                                toastr.error('Organization not found.');
                            } else {
                                $('#updateOrganization').modal('show');
                                var designation =
                                    response; // response is already the department data
                                $('#organization_id').val(designation.id);
                                $('#update_name').val(designation.name);
                                $('#update_status').val(designation.status);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Organization.');
                        }
                    });
                });

                $('#updateOrganizationForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#organization_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateOrganizationForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "<?php echo e(route('update_organization_form', ['id' => ':id'])); ?>".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateOrganization').modal('hide');
                                $('#organization_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateOrganizationForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/super_admin/organization/organization.blade.php ENDPATH**/ ?>