<?php

namespace App\DataTables;

use Yajra\DataTables\Services\DataTable;
use Illuminate\Support\Facades\Http;

class EmployeeDataTable extends DataTable
{
    public function dataTable($query)
    {
        return datatables()
            ->collection($query)
            ->addIndexColumn()
            ->addColumn('image', function ($row) {
                $imageUrl = $row['user_profile']['image'] ?? 'default-image.png';
                // Prepend the API base URL if the image path is relative
                if (!filter_var($imageUrl, FILTER_VALIDATE_URL)) {
                    $imageUrl = env('API_URL_FOR_IMAGE', 'http://localhost:8000') . '/' . ltrim($imageUrl, '/');
                }
                return '<img src="' . $imageUrl . '" width="50" height="50">';
            })
            ->addColumn('name', function ($row) {
                return $row['user_profile']['user']['name'] ?? 'N/A';
            })
            ->addColumn('email', function ($row) {
                return $row['user_profile']['user']['email'] ?? 'N/A';
            })
            ->addColumn('department', function ($row) {
                return $row['department']['department'] ?? 'N/A';
            })
            ->addColumn('designation', function ($row) {
                return $row['designation']['designation'] ?? 'N/A';
            })
            ->addColumn('phone', function ($row) {
                return $row['user_profile']['phone'] ?? 'N/A';
            })
            ->addColumn('address', function ($row) {
                return $row['user_profile']['address'] ?? 'N/A';
            })
            ->rawColumns(['image']);
    }

    public function query()
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL', 'http://localhost:8000');
        $response = Http::withToken($token)->get("$apiBaseUrl/employees");

        if ($response->successful()) {
            return collect($response->json()['employees']);
        }

        return collect([]);
    }

    public function html()
    {
        // This method is not needed when using custom HTML,
        // but we'll keep it empty in case it's called somewhere
        return $this->builder();
    }
}