<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;


class DeductionController extends Controller
{
    private function fetch_employees(): array
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->get("{$apiBaseUrl}/employees");
    
        if ($response->successful()) {
            // Fetch the employee data including related user name
            $employees = $response->json()['employees'] ?? [];
            
            // Extract only the employee ID and the associated user name
            $employees = array_map(function ($employee) {
                return [
                    'id' => $employee['id'], // Employee ID
                    'name' => $employee['user_profile']['user']['name'] ?? null, // Associated User's Name
                ];
            }, $employees);
    
            return $employees;
        }
    
        return [];
    }
    
    public function deduction_list()
    {
        $employees = $this->fetch_employees();
        return view('admin.settings.deduction',compact('employees'));
    }


    public function add_deduction_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $org_id = session('org_id');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/deductions/store", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => 'active',
                'org_id' => $org_id
            ]);
          
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Deduction added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'errors' => $error['errors'] ?? 'Failed to add Deduction.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_deduction_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the education
            $response = Http::withToken($token)->put("{$apiBaseUrl}/deductions/update/{$id}", [
                'employee_id' => $request->employee_id,
                'amount' => $request->amount,
                'date' => $request->date,
                'reason' => $request->reason,
                'status' => 'active',
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Deduction updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'errors' => $error['errors'] ?? 'Failed to update Deduction.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_deduction($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/deductions/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Deduction deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Deduction'
            ], $response->status());
        }
    }

    public function get_deduction($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/deductions/get/{$id}");
    
           
    
            if ($response->successful()) {
                // Return the education data from the API response
             
                $deduction = $response->json()['deduction'];
                return response()->json($deduction);
            } else {
                return response()->json(['status' => 404, 'message' => 'Deduction not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
