<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\DataTables\Settings\JobTypeDataTable;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;

class JobTypeController extends Controller
{
    public function job_type_list()
    {
        return view('admin.settings.job_type');
    }
    public function add_job_type_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/job_types/store", [
                'job_type' => $request->job_type,
                'org_id' => $org_id
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Job Type added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'errors' => $error['errors'] ?? 'Failed to add Job Type.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_job_type_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the department
            $response = Http::withToken($token)->put("{$apiBaseUrl}/job_types/update/{$id}", [
                'job_type' => $request->job_type,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Job Type updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                 'errors' => $error['errors']  ?? 'Failed to update Job Type.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_job_type($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/job_types/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Job Type deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Job Type'
            ], $response->status());
        }
    }

    public function get_job_type($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/job_types/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the department data from the API response
                return response()->json($response->json()['job_type']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Job Type not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
