@extends('admin.layout.main')

@section('content')
    <style>
        .card .card-body {
            padding: 1rem 1rem !important;
        }


        .btn-facebook {
            background: #E11C44 !important;
        }

        .btn-twitter {
            background: #F5A623 !important;
        }

        .btn-google {
            background: #1abc9c !important;
        }
    </style>

    <div class="main-panel">
        <div class="content-wrapper">






            @if (session('role') === 'organization')
                <div class="row mt-3">
                    <div class="col-md-3 grid-margin">
                        <div class="card h-100" style="background-color: #96E29D">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <img src="{{ asset('assets/images/first.png') }}" class="p-1"
                                            style="background-color:#41D85A; width:100%;max-width:60px; border-radius:5px"
                                            alt="">
                                    </div>
                                    <div class="col-sm-6 text-right">
                                        <div class="pt-2">
                                            <div class="mb-2">
                                                <h4 class="card-title mb-0">Monthly</h4>
                                            </div>
                                            <small class="text-muted"><i class="icon-clock mr-1"></i>215 hrs 00 min.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card h-100" style="background-color: #FFC5BB;">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <img src="{{ asset('assets/images/second.png') }}" class="p-2"
                                            style="background-color:#FF947A; width:100%;max-width:60px; border-radius:5px"
                                            alt="">
                                    </div>
                                    <div class="col-sm-6 text-right">
                                        <div class="pt-2">
                                            <div class="mb-2">
                                                <h4 class="card-title mb-0">Weekly</h4>
                                            </div>
                                            <small class="text-muted"><i class="icon-clock mr-1"></i>54 hr 00 min.</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card h-100" style="background-color: #DEC5FF">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-sm-6">
                                        <img src="{{ asset('assets/images/third.png') }}" class="p-2"
                                            style="background-color:#BF83FE; width:100%;max-width:60px; border-radius:5px"
                                            alt="">
                                    </div>
                                    <div class="col-sm-6 text-right">
                                        <div class="pt-2">
                                            <div class="mb-2">
                                                <h4 class="card-title mb-0">Employee Leaves</h4>
                                            </div>
                                            <small class="text-gray">22 Casual Leaves</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card h-100" style="background-color: #FFD683">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <img src="{{ asset('assets/images/first.png') }}" class="p-2"
                                            style="background-color:#FAAF40; width:100%;max-width:60px; border-radius:5px"
                                            alt="">
                                    </div>
                                    <div class="col-sm-6 text-right">
                                        <div class="pt-2">
                                            <div>
                                                <h4 class="card-title mb-2">Code of conduct</h4>

                                                <small class="text-muted">Ethical Code.</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12 mb-2">
                        <h4>Overview</h4>
                    </div>
                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #96E29D">Employees</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['total_profiles'] }}</h4>
                                        </div>
                                        <small class="text-gray">Total Employees</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #96E29D">
                                        <i class="icon-people text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin" style="cursor: pointer;" id="reminder-card">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #FF947A">Reminder</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['documentsWithReminders'] }}</h4>
                                        </div>
                                        <small class="text-gray">Total Reminder</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #FF947A">
                                        <i class="icon-user text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="reminderModal" tabindex="-1" aria-labelledby="reminderModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="reminderModalLabel">Document Reminders</h5>
                                </div>
                                <div class="modal-body">
                                    <table class="table-bordered table" id="reminder-table">
                                        <thead>
                                            <tr>
                                                <th>Document Name</th>
                                                <th>Employee Name</th>
                                                <th>Expiry Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #DEC5FF">Salaries - {{ session('currency') }}</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                        <h4 class="fw-normal mb-0">{{ $data['salaries'] }}</h4>

                                        </div>
                                        <small class="text-gray">Total Salaries</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #DEC5FF">
                                        <i class="icon-user-female text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #FAAF40">New Employees</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['last_week_profiles'] }}</h4>
                                        </div>
                                        <small class="text-gray">Last 30 Days </small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #FAAF40">
                                        <i class="icon-people text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12 mb-2">
                        <h4>Notifications</h4>
                    </div>

                    <div class="col-md-4 mb-2">
                        <div style="background-color: #fff; border-radius:5px; padding:.50rem !important">
                            <div class="row">
                                <div class="col-md-3 mt-2 text-center">
                                    <img src="{{ asset('assets/images/faces/face3.jpg') }}" class="rounded-circle"
                                        alt="profile image" style="width: 100%; max-width:70px" />
                                </div>
                                <div class="col-md-9 mt-3">
                                    <h5>A goal without a plan is just a wish.</h5>
                                    <p>Stay Blessed</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 mb-2">
                        <div class="p-3" style="background-color: #fff; border-radius:5px;">
                            <div class="row">
                                <div class="col-md-3 bg-danger p-3 text-center" style="border-radius:5px;">
                                    <i class="fa fa-bell text-white" style="font-size: 30px;"></i>
                                </div>
                                <div class="col-md-9 ">
                                    <p class="mt-2">
                                        You have <strong>0</strong> new notifications.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>





                    <div class="col-md-4 mb-2">
                        <div class="text-center"
                            style="background-image: url('{{ asset('assets/images/birthday-admin-dashboard.jpg') }}'); border-radius: 5px; background-position: center; background-size: cover; height: 95px; display: flex; justify-content: center; align-items: center;">
                            <div class="row">
                                @if (isset($data['birthday']['employee']) && !empty($data['birthday']['employee']['date_of_birth']))
                                    @php
                                        // Parse date of birth and calculate age and month name
                                        $dateOfBirth = \Carbon\Carbon::parse(
                                            $data['birthday']['employee']['date_of_birth'],
                                        );
                                        $age = \Carbon\Carbon::now()->diffInYears($dateOfBirth);
                                        $monthName = $dateOfBirth->format('F'); // Full month name
                                    @endphp

                                    <div class="col-xs-4 mt-3 text-right">
                                        <img src="{{ $data['birthday']['employee']['image'] }}" alt="Employee Image"
                                            style="width:100%; max-width:60px; clip-path: circle(50% at 50% 50%);">
                                    </div>
                                    <div class="col-xs-7 ms-2">
                                        <p class="py-4" style="padding: 0px 10px">
                                            <span>Next Birthday</span> <br>
                                            <strong class="text-danger px-2" style="background-color: #f5a3b4">
                                                {{ $data['birthday']['employee']['name'] }}
                                            </strong>
                                            <br>
                                           
                                        </p>
                                    </div>
                                @else
                                    <h5>No Upcoming Birthday Found</h5>
                                @endif

                            </div>
                        </div>
                    </div>



                </div>
            @endif

            @if (session('role') === 'admin')
                <div class="row mt-3">
                    <div class="col-12 mb-2">
                        <h4>Overview</h4>
                    </div>
                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #96E29D">Organizations</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['totalOrganizations'] }}</h4>
                                        </div>
                                        <small class="text-gray">Total Organizations</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #96E29D">
                                        <i class="icon-people text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #FF947A">Users</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['totalUsers'] }}</h4>
                                        </div>
                                        <small class="text-gray">Total Users</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #FF947A">
                                        <i class="icon-user text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #DEC5FF">New Organizations</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['totalOrganizationsLastMonth'] }}</h4>
                                        </div>
                                        <small class="text-gray">Last 30 Days</small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #DEC5FF">
                                        <i class="icon-user-female text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 grid-margin">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title font-weight-bold mb-0" style="color: #FAAF40">New Users</h4>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="d-inline-block pt-3">
                                        <div class="d-md-flex mb-2">
                                            <h4 class="mb-0">{{ $data['totalUsersLastMonth'] }}</h4>
                                        </div>
                                        <small class="text-gray">Last 30 Days </small>
                                    </div>
                                    <div class="d-inline-block p-3" style="background-color: #FAAF40">
                                        <i class="icon-people text-white" style="font-size: 35px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>




        <footer class="footer">
            <div class="d-sm-flex justify-content-center justify-content-sm-between">
                <span class="text-muted text-sm-left d-block d-sm-inline-block text-center">    
                    Copyright © <?php echo date("Y"); ?>. All rights reserved.</span>
                <span class="float-sm-right d-block mt-sm-0 float-none mt-1 text-center">Hand-crafted & made
                    with <i class="far fa-heart text-danger"></i></span>
            </div>
        </footer>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script>
            $(document).ready(function() {
                $('#reminder-card').on('click', function() {
                    $.ajax({
                        url: 'https://microsols.com.au/devioo/public' + '/api/dashboard/reminders',
                        type: 'GET',
                        headers: {
                            'Authorization': 'Bearer ' +
                                '{{ session('bearer_token') }}', // Get the Bearer token from session
                            'Accept': 'application/json',
                        },
                        success: function(response) {
                            if (response.documentsWithReminders.length > 0) {
                                let tableBody = $('#reminder-table tbody');
                                tableBody.empty(); // Clear any existing rows
                                $.each(response.documentsWithReminders, function(index, doc) {
                                    tableBody.append(`
                                    <tr>
                                        <td>${doc.name}</td>
                                        <td>${doc.employee_name}</td>
                                        <td>${doc.expiry_date}</td>
                                        <td><a href="${doc.document_url}" class="btn btn-sm btn-primary" target="_blank">View</a></td>
                                    </tr>
                                `);
                                });
                            }
                            $('#reminderModal').modal('show');
                        },
                        error: function(error) {
                            console.error('Error fetching reminders:', error);
                        }
                    });
                });
            });
        </script>
    @endsection
