<?php $__env->startSection('content'); ?>
    <style>
        .tab-content {
            border: none;
            position: relative;
        }

        #loader {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            /* Ensure loader appears above other content */
        }

        .tab-content form .form-group {
            margin-bottom: 20px;

        }

        .nav-tabs .nav-link.active {
            background-color: #2B2155;
            color: white;
            border-color: #2B2155;
        }

        .nav-tabs .nav-link {
            color: #2B2155;
        }

        .card {
            width: 100%;
        }

        .card-body {
            padding: 30px;
        }

        .float-right {
            margin-left: 10px;
        }

        .float-left {
            margin-right: 10px;
        }
    </style>


    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Create Employee
                </h3>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Create Employee</li>
                    </ol>
                </nav>
            </div>

            <div class="card col-md-8 mx-auto">
                <div class="card-body" id="firstCardBody">
                    <!-- Tab Navigation -->
                    <ul class="nav nav-tabs" id="employeeTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="credentials-tab" data-toggle="tab-disabled" href="#credentials"
                                role="tab" aria-controls="credentials" aria-selected="true">Employee Credentials</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-tab" data-toggle="tab-disabled" href="#profile" role="tab"
                                aria-controls="profile" aria-selected="false">Employee Profile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="details-tab" data-toggle="tab-disabled" href="#details" role="tab"
                                aria-controls="details" aria-selected="false">Employee Details</a>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content mt-1" id="employeeTabContent">
                        <!-- Employee Credentials Tab -->
                        <div class="tab-pane fade show active" id="credentials" role="tabpanel"
                            aria-labelledby="credentials-tab">
                            <div id="loader">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <h4 class="mb-3">Employee Credentials</h4>
                            <form class="mt-4" id="employe_form" method="POST">
                                <?php echo csrf_field(); ?>
                                <div id="first_api">
                                    <div class="form-group">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            placeholder="Enter name">
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            placeholder="Enter email">
                                    </div>
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password"
                                            placeholder="Enter password">
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">Confirm Password</label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" placeholder="Confirm password">
                                    </div>
                                </div>
                                <button type="button" class="btn btn-primary next-btn float-right"
                                    style="background-color: #2B2155;">Next</button>
                        </div>

                        <!-- Employee Profile Tab -->
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <h4 class="mb-3">Employee Profile</h4>
                            <div id="second_api" class="row">
                                <div class="col-6">

                                    <div class="form-group">
                                        <label for="phone">Phone</label>
                                        <input type="number" class="form-control" id="phone" name="phone"
                                            placeholder="Enter phone number">
                                    </div>
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            placeholder="Enter address">
                                    </div>
                                    <div class="form-group">
                                        <label for="cnic">Cnic</label>
                                        <input type="text" class="form-control" id="cnic" name="cnic"
                                            placeholder="Enter cnic">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="gender">Gender</label>
                                        <select type="text" class="form-control" id="gender" name="gender"
                                            style="height: 46px;">
                                            <option disabled selected> Select Gender</option>
                                            <option value="male"> Male</option>
                                            <option value="female"> Female</option>
                                            <option value="other"> Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">Date of Birth</label>
                                        <input type="date" class="form-control" id="date_of_birth"
                                            name="date_of_birth" placeholder="Enter Date of Birth">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="image">Profile Image</label>
                                        <input type="file" class="form-control file" id="image" name="image">
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="button" class="btn btn-primary next-btn float-right"
                                style="background-color: #2B2155;">Next</button>
                        </div>

                        <!-- Employee Details Tab -->
                        <div class="tab-pane fade" id="details" role="tabpanel" aria-labelledby="details-tab">
                            <h4 class="mb-3">Employee Details</h4>
                            <div class="row mt-4" id="third_api">

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="department_id">Department</label>
                                        <select type="text" class="form-control" id="department_id"
                                            name="department_id" style="height: 46px;">
                                            <option selected disabled>Select Department</option>
                                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($department['id']); ?>"><?php echo e($department['department']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="joining_date">Joining Date</label>
                                        <input type="date" class="form-control" id="joining_date" name="joining_date"
                                            placeholder="Enter joining date">
                                    </div>
                                    <div class="form-group">
                                        <label for="allowances_id">Allowances</label>
                                        <select type="text" class="form-control" id="allowances_id"
                                            name="allowances_id" style="height: 46px;">
                                            <option selected disabled>Select Allowances</option>
                                            <?php $__currentLoopData = $allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($allowance['id']); ?>"><?php echo e($allowance['name']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shift_id">Shift</label>
                                        <select type="text" class="form-control" id="shift_id" name="shift_id"
                                            style="height: 46px;">
                                            <option selected disabled>Select Shift</option>
                                            <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($shift['id']); ?>"><?php echo e($shift['shift']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="job_type_id">Job Type</label>
                                        <select type="text" class="form-control" id="job_type_id" name="job_type_id"
                                            style="height: 46px;">
                                            <option selected disabled>Select Job Type</option>
                                            <?php $__currentLoopData = $job_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($job_type['id']); ?>"><?php echo e($job_type['job_type']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">

                                    <div class="form-group">
                                        <label for="designation_id">Designation</label>
                                        <select type="text" class="form-control" id="designation_id"
                                            name="designation_id" style="height: 46px;">
                                            <option selected disabled>Select Designation</option>

                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="joining_date">Salary</label>
                                        <input type="number" class="form-control" id="salary" name="salary"
                                            placeholder="Enter joining salary">
                                    </div>
                                    <div class="form-group">
                                        <label for="joining_date">Total Leaves</label>
                                        <input type="number" class="form-control" id="total_leaves" name="total_leaves"
                                            placeholder="Enter total leaves">
                                    </div>
                                    <div class="form-group">
                                        <label for="salary_type_id">Salary Type</label>
                                        <select type="text" class="form-control" id="salary_type_id"
                                            name="salary_type_id" style="height: 46px;">
                                            <option selected disabled>Select Salary Type</option>
                                            <?php $__currentLoopData = $salary_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($salary_type['id']); ?>">
                                                    <?php echo e($salary_type['salary_type']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="submit" class="btn btn-success float-right">Submit</button>
                            </form>
                        </div>
                    </div>


                </div>


                <div class="card-body mt-2" id="SecondCardBody">
                    <!-- Tab Navigation -->
                    <ul class="nav nav-tabs" id="employeeDetailTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="education-tab" data-toggle="tab" href="#education"
                                role="tab" aria-controls="education" aria-selected="true">Employee Education</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="work-history-tab" data-toggle="tab" href="#work_history"
                                role="tab" aria-controls="work_history" aria-selected="false">Employee Work
                                History</a>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content mt-1" id="employeeDetailTabContent">
                        <!-- Employee Education Tab -->
                        <div class="tab-pane fade show active" id="education" role="tabpanel"
                            aria-labelledby="education-tab">
                            <div id="education-loader">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <h4 class="mb-3">Employee Education</h4>
                            <form class="mt-4" id="employee_education_form" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div id="education_fields" class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="institute_name">Institute Name</label>
                                            <input type="text" class="form-control" id="institute_name"
                                                name="institute_name" placeholder="Enter institute name">
                                        </div>
                                        <div class="form-group">
                                            <label for="last_degree">Last Degree</label>
                                            <input type="text" class="form-control" id="last_degree"
                                                name="last_degree" placeholder="Enter last degree">
                                        </div>
                                        <div class="form-group">
                                            <label for="campus">Campus</label>
                                            <input type="text" class="form-control" id="campus" name="campus"
                                                placeholder="Enter campus">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="session_start">Session Start</label>
                                            <input type="date" class="form-control" id="session_start"
                                                name="session_start" placeholder="Enter session start">
                                        </div>
                                        <div class="form-group">
                                            <label for="session_end">Session End</label>
                                            <input type="date" class="form-control" id="session_end"
                                                name="session_end" placeholder="Enter session end">
                                        </div>
                                        <div class="form-group">
                                            <label for="attach_file">Attach File</label>
                                            <input type="file" class="form-control" id="attach_file"
                                                name="attach_file" placeholder="Attach file">
                                        </div>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-primary next-btn float-right"
                                    style="background-color: #2B2155;">Next</button>

                        </div>

                        <!-- Employee Work History Tab -->
                        <div class="tab-pane fade" id="work_history" role="tabpanel" aria-labelledby="work-history-tab">
                            <h4 class="mb-3">Employee Work History</h4>


                            <div id="work_history_fields" class="row">
                                <div class="form-group col-md-6">
                                    <label for="company_name">Company Name</label>
                                    <input type="text" class="form-control" id="company_name" name="company_name"
                                        placeholder="Enter company name">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="work_designation">Designation</label>
                                    <input type="text" class="form-control" id="work_designation" name="designation"
                                        placeholder="Enter designation">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="work_joining_date">Joining Date</label>
                                    <input type="date" class="form-control" id="work_joining_date"
                                        name="joining_date" placeholder="Enter joining date">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="leaving_date">Leaving Date</label>
                                    <input type="date" class="form-control" id="leaving_date" name="leaving_date"
                                        placeholder="Enter leaving date">
                                </div>
                                <div class="form-group col-md-12">
                                    <label for="leaving_reason">Reason</label>
                                    <textarea class="form-control" id="leaving_reason" rows="3" name="reason" placeholder="Enter reason"></textarea>
                                </div>
                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="submit" class="btn btn-success float-right">Submit</button>
                            <a style="background-color: #2B2155;" href="<?php echo e(route('employees_index')); ?>"
                                class="btn btn-secondary float-right">Skip</a>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>




    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"></script>
    <!-- Include Toastify CSS and JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

    <script>
        $('.dropify').dropify();
    </script>
    <script>
        $('#department_id').on('change', function() {
            var departmentId = $(this).val(); // Get the selected department ID

            // Make an AJAX request to get designations for the selected department
            $.ajax({
                url: "<?php echo e(route('get_department', ':id')); ?>".replace(':id',
                departmentId), // Using route helper with dynamic ID
                type: 'GET',
                success: function(response) {
                    // Clear the current options in the designation dropdown
                    $('#designation_id').empty();

                    // Add a default 'Select Designation' option
                    $('#designation_id').append(
                    '<option selected disabled>Select Designation</option>');

                    // Check if there are designations in the response
                    if (response.designations && response.designations.length > 0) {
                        // Loop through each designation and append to the dropdown
                        response.designations.forEach(function(designation) {
                            $('#designation_id').append('<option value="' + designation.id +
                                '">' + designation.designation + '</option>');
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('An error occurred:', error);
                    // Optionally show an alert or message to the user
                }
            });
        });
    </script>


    <script>
        $('#SecondCardBody').hide();

        function validateImageSize(input) {
            if (input.files && input.files[0]) {
                if (input.files[0].size > 2 * 1024 * 1024) { // 2 MB limit
                    Toastify({
                        text: "The image must be smaller than 2 MB.",
                        duration: 3000,
                        gravity: "top",
                        position: "right",
                        backgroundColor: "#e74c3c", // Red color for error
                    }).showToast();
                    input.value = ''; // Clear the input field
                }
            }
        }
        $(document).ready(function() {
            function showToastError(message) {
                Toastify({
                    text: message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: "right",
                    backgroundColor: "#ff6b6b",
                }).showToast();
            }

            function validateCredentials() {
                const name = $('#name').val().trim();
                const email = $('#email').val().trim();
                const password = $('#password').val().trim();
                const passwordConfirmation = $('#password_confirmation').val().trim();

                if (!name) return 'Name is required.';
                if (!email) return 'Email is required.';
                if (!password) return 'Password is required.';
                if (!passwordConfirmation) return 'Password confirmation is required.';
                if (password.length < 8) return 'Password must be at least 8 characters long.';
                if (password !== passwordConfirmation) return 'Passwords do not match.';



                return null;
            }

            function validateProfile() {
                const phone = $('#phone').val().trim();
                const address = $('#address').val().trim();
                const cnic = $('#cnic').val().trim();
                const gender = $('#gender').val();
                const dateOfBirth = $('#date_of_birth').val();
                const image = $('#image').val();

                if (!phone) return 'Phone number is required.';
                if (!address) return 'Address is required.';
                if (!cnic) return 'CNIC is required.';
                if (!gender) return 'Gender is required.';
                if (!dateOfBirth) return 'Date of Birth is required.';
                if (!image) return 'Profile image is required.';

                return null;
            }

            function validateDetails() {
                const fields = [{
                        id: 'department_id',
                        name: 'Department'
                    },
                    {
                        id: 'designation_id',
                        name: 'Designation'
                    },

                    {
                        id: 'shift_id',
                        name: 'Shift'
                    },
                    {
                        id: 'job_type_id',
                        name: 'Job Type'
                    },
                    {
                        id: 'joining_date',
                        name: 'Joining Date'
                    },
                    {
                        id: 'salary',
                        name: 'Salary'
                    },
                    {
                        id: 'total_leaves',
                        name: 'Total Leaves'
                    },
                    {
                        id: 'salary_type_id',
                        name: 'Salary Type'
                    },

                ];

                for (let field of fields) {
                    if (!$(`#${field.id}`).val()) {
                        return `${field.name} is required.`;
                    }
                }

                return null;
            }

            // Next button click event
            $('.next-btn').on('click', function() {
                const currentTab = $('.nav-tabs .nav-link.active').attr('id');
                let error = null;

                switch (currentTab) {
                    case 'credentials-tab':
                        error = validateCredentials();
                        break;
                    case 'profile-tab':
                        error = validateProfile();
                        break;
                    case 'details-tab':
                        error = validateDetails();
                        break;
                }

                if (error) {
                    showToastError(error);
                } else {
                    const $activeTab = $('.nav-tabs .nav-link.active');
                    const $nextTab = $activeTab.parent().next().find('a');

                    if ($nextTab.length) {
                        $activeTab.removeClass('active').attr('aria-selected', 'false');
                        $nextTab.addClass('active').attr('aria-selected', 'true');
                        $nextTab.tab('show'); // Switch the tab

                        // Also switch the tab content
                        const nextPaneId = $nextTab.attr('href');
                        $('.tab-pane').removeClass('active show'); // Hide all content
                        $(nextPaneId).addClass('active show'); // Show the next tab's content
                    }
                }
            });

            // Previous button click event
            $('.prev-btn').on('click', function() {
                const $activeTab = $('.nav-tabs .nav-link.active');
                const $prevTab = $activeTab.parent().prev().find('a');

                if ($prevTab.length) {
                    $activeTab.removeClass('active').attr('aria-selected', 'false');
                    $prevTab.addClass('active').attr('aria-selected', 'true');
                    $prevTab.tab('show'); // Switch the tab

                    // Also switch the tab content
                    const prevPaneId = $prevTab.attr('href');
                    $('.tab-pane').removeClass('active show'); // Hide all content
                    $(prevPaneId).addClass('active show'); // Show the previous tab's content
                }
            });

            // Disable manual tab switching by preventing clicks on the tab navigation
            $('.nav-tabs a').on('click', function(e) {
                e.preventDefault();
            });

            // Form submission
            $('#employe_form').on('submit', function(e) {
                e.preventDefault();

                const imageInput = document.getElementById('image');
                if (imageInput.files.length > 0 && imageInput.files[0].size > 2 * 1024 * 1024) {
                    showToastError("The image must be smaller than 2 MB.");
                    return;
                }

                const credentialsError = validateCredentials();
                const profileError = validateProfile();
                const detailsError = validateDetails();

                if (credentialsError) {
                    showToastError(credentialsError);
                    $('#credentials-tab').tab('show');
                    return;
                }

                if (profileError) {
                    showToastError(profileError);
                    $('#profile-tab').tab('show');
                    return;
                }

                if (detailsError) {
                    showToastError(detailsError);
                    $('#details-tab').tab('show');
                    return;
                }

                // If all validations pass, submit the form
                const formData = new FormData(this);

                $.ajax({
                    url: "<?php echo e(route('add_employee_form')); ?>", // Replace with your actual endpoint
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        Toastify({
                            text: "Employee added successfully!",
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: "right",
                            backgroundColor: "#4CAF50",
                        }).showToast();
                        // window.location.href = '<?php echo e(route('employees_index')); ?>';
                        console.log(response);

                        $('#firstCardBody').hide();
                        $('#SecondCardBody').show();

                        $('#employeeDetailTab a[href="#education"]').tab('show');
                    },
                    error: function(xhr) {
                        const errorMessage = xhr.responseJSON && xhr.responseJSON.message ?
                            xhr.responseJSON.message :
                            'An error occurred while submitting the form.';
                        showToastError(errorMessage);
                    }
                });
            });
            $('#employee_education_form').on('submit', function(e) {
                e.preventDefault();

                let $submitButton = $('#employee_education_form button[type="submit"]');
                $submitButton.prop('disabled', true); // Disable button to prevent multiple submissions

                $.ajax({
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "<?php echo e(route('add_employee_details')); ?>",
                    data: $(this).serialize(),
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.success);
                            window.location.href =
                                '<?php echo e(route('employees_index')); ?>'; // Redirect on success
                        } else {
                            handleValidationErrors(response.errors); // Handle validation errors
                        }
                    },
                    error: function(xhr) {
                        let errorsQueue = [];

                        if (xhr.status === 422) { // Validation error from the backend
                            let errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, error) {
                                // Show first error for each field
                                errorsQueue.push(error[0]);
                            });
                        } else if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorsQueue.push(xhr.responseJSON.message); // General error message
                        } else {
                            errorsQueue.push('An error occurred. Please try again.');
                        }

                        // Display errors one by one
                        displayErrors(errorsQueue);
                    },
                    complete: function() {
                        $submitButton.prop('disabled',
                            false); // Re-enable the submit button after the request completes
                    }
                });
            });

            function displayErrors(errorsQueue) {
                if (errorsQueue.length > 0) {
                    let error = errorsQueue.shift(); // Show the first error message
                    toastr.error(error, '', {
                        onHidden: function() {
                            // Check if there are more errors to show
                            if (errorsQueue.length > 0) {
                                displayErrors(errorsQueue); // Recursively display remaining errors
                            }
                        }
                    });
                }
            }



        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/employee/create_employee.blade.php ENDPATH**/ ?>