
<?php $__env->startSection('content'); ?>
    <style>
        .tab-content {
            border: none;
            position: relative;
        }

        #loader {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            /* Ensure loader appears above other content */
        }

        .tab-content form .form-group {
            margin-bottom: 20px;

        }

        .nav-tabs .nav-link.active {
            background-color: #2B2155;
            color: white;
            border-color: #2B2155;
        }

        .nav-tabs .nav-link {
            color: #2B2155;
        }

        .card {
            width: 100%;
        }

        .card-body {
            padding: 30px;
        }

        .float-right {
            margin-left: 10px;
        }

        .float-left {
            margin-right: 10px;
        }
     
    </style>


    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Create Employee
                </h3>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Create Employee</li>
                    </ol>
                </nav>
            </div>

            <div class="card col-md-8 mx-auto">
                <div class="card-body">
                    <!-- Tab Navigation -->
                    <ul class="nav nav-tabs" id="employeeTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="credentials-tab" data-toggle="tab" href="#credentials"
                                role="tab" aria-controls="credentials" aria-selected="true">Employee Credentials</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab"
                                aria-controls="profile" aria-selected="false">Employee Profile</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="details-tab" data-toggle="tab" href="#details" role="tab"
                                aria-controls="details" aria-selected="false">Employee Details</a>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content mt-1" id="employeeTabContent">
                        <!-- Employee Credentials Tab -->
                        <div class="tab-pane fade show active" id="credentials" role="tabpanel"
                            aria-labelledby="credentials-tab">
                            <div id="loader">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <h4 class="mb-3">Employee Credentials</h4>
                            <form class="mt-4" id="employe_form">
                                <?php echo csrf_field(); ?>
                                <div id="first_api">
                                    <div class="form-group">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            placeholder="Enter name" >
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            placeholder="Enter email" >
                                    </div>
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password"
                                            placeholder="Enter password" >
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">Confirm Password</label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" placeholder="Confirm password" >
                                    </div>
                                </div>
                                <button type="button" class="btn btn-primary next-btn float-right"
                                    style="background-color: #2B2155;">Next</button>
                        </div>

                        <!-- Employee Profile Tab -->
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <h4 class="mb-3">Employee Profile</h4>
                            <div id="second_api" class="row">
                                <div class="col-6">
                                    <input type="hidden" name="user_id" id="user_id">
                                    <div class="form-group">
                                        <label for="phone">Phone</label>
                                        <input type="number" class="form-control" id="phone" name="phone"
                                            placeholder="Enter phone number" >
                                    </div>
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            placeholder="Enter address" >
                                    </div>
                                    <div class="form-group">
                                        <label for="cnic">Cnic</label>
                                        <input type="text" class="form-control" id="cnic" name="cnic"
                                            placeholder="Enter cnic" >
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="gender">Gender</label>
                                        <select type="text" class="form-control" id="gender" name="gender" style="height: 46px;" >
                                            <option disabled selected> Select Gender</option>
                                            <option value="male"> Male</option>
                                            <option value="female"> Female</option>
                                            <option value="other"> Other</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="date_of_birth">Date of Birth</label>
                                        <input type="date" class="form-control" id="date_of_birth"
                                            name="date_of_birth" placeholder="Enter Date of Birth" >
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="image">Profile Image</label>
                                        <input type="file" class="form-control-file dropify" id="image"
                                            name="image" >
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="button" class="btn btn-primary next-btn float-right"
                                style="background-color: #2B2155;">Next</button>
                        </div>

                        <!-- Employee Details Tab -->
                        <div class="tab-pane fade" id="details" role="tabpanel" aria-labelledby="details-tab">
                            <h4 class="mb-3">Employee Details</h4>
                            <div class="row mt-4" id="third_api">
                                <input type="hidden" name="user_profile_id" id="user_profile_id">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="department_id">Department</label>
                                        <select type="text" class="form-control" id="department_id"
                                            name="department_id"  style="height: 46px;">
                                            <option selected disabled>Select Department</option>
                                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($department['id']); ?>"><?php echo e($department['department']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="designation_id">Designation</label>
                                        <select type="text" class="form-control" id="designation_id"
                                            name="designation_id"  style="height: 46px;">
                                            <option selected disabled>Select Designation</option>
                                            <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($designation['id']); ?>"><?php echo e($designation['designation']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="allowances_id">Allowances</label>
                                        <select type="text" class="form-control" id="allowances_id"
                                            name="allowances_id"  style="height: 46px;">
                                            <option selected disabled>Select Allowances</option>
                                            <?php $__currentLoopData = $allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($allowance['id']); ?>"><?php echo e($allowance['allowance']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="shift_id">Shift</label>
                                        <select type="text" class="form-control" id="shift_id" name="shift_id"  style="height: 46px;">
                                            <option selected disabled>Select Shift</option>
                                            <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($shift['id']); ?>"><?php echo e($shift['shift']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="job_type_id">Job Type</label>
                                        <select type="text" class="form-control" id="job_type_id" name="job_type_id"  style="height: 46px;">
                                            <option selected disabled>Select Job Type</option>
                                            <?php $__currentLoopData = $job_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($job_type['id']); ?>"><?php echo e($job_type['job_type']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label for="joining_date">Joining Date</label>
                                        <input type="date" class="form-control" id="joining_date" name="joining_date" 
                                            placeholder="Enter joining date">
                                    </div>
                                    <div class="form-group">
                                        <label for="salary_id">Salary</label>
                                        <select type="text" class="form-control" id="salary_id" name="salary_id"  style="height: 46px;">
                                            <option selected disabled>Select Salary</option>
                                            <?php $__currentLoopData = $salaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($salary['id']); ?>"><?php echo e($salary['salary']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="salary_type_id">Salary Type</label>
                                        <select type="text" class="form-control" id="salary_type_id"
                                            name="salary_type_id"  style="height: 46px;">
                                            <option selected disabled>Select Salary Type</option>
                                            <?php $__currentLoopData = $salary_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($salary_type['id']); ?>">
                                                    <?php echo e($salary_type['salary_type']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="education_id">Education</label>
                                        <select type="text" class="form-control" id="education_id"
                                            name="education_id"  style="height: 46px;">
                                            <option selected disabled>Select Education</option>
                                            <?php $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($education['id']); ?>"><?php echo e($education['education']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="work_history_id">Work History</label>
                                        <select type="text" class="form-control" id="work_history_id"
                                            name="work_history_id"  style="height: 46px;">
                                            <option selected disabled>Select Work History</option>
                                            <?php $__currentLoopData = $work_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($history['id']); ?>"><?php echo e($history['work_history']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="submit" class="btn btn-success float-right">Submit</button>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"></script>
        <!-- Include Toastify CSS and JS -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
        <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

        <script>
            $('.dropify').dropify();
        </script>
        <script>
            $(document).ready(function() {
                // Handle "Next" button click
                $('.next-btn').click(function() {
                    var activeTab = $('.nav-tabs .active');
                    var nextTab = activeTab.closest('li').next('li').find('a');
                    if (nextTab.length) {
                        nextTab.tab('show');
                    }
                });

                // Handle "Previous" button click
                $('.prev-btn').click(function() {
                    var activeTab = $('.nav-tabs .active');
                    var prevTab = activeTab.closest('li').prev('li').find('a');
                    if (prevTab.length) {
                        prevTab.tab('show');
                    }
                });
            });
        </script>

        <script>
            $(document).ready(function() {
                // Retrieve the token from the session
                var bearerToken = "<?php echo e(session('bearer_token')); ?>";
                var orgId = "<?php echo e(session('org_id')); ?>";
                // Show the loader
                function showLoader() {
                    $('#loader').show();
                }

                // Hide the loader
                function hideLoader() {
                    $('#loader').hide();
                }

                $('#employe_form').on('submit', function(e) {
                    e.preventDefault(); // Prevent default form submission

                    // Disable the submit button to prevent multiple clicks
                    $('.btn-success').prop('disabled', true);

                    // Show the loader
                    showLoader();

                    console.log("Form submitted, starting API calls");

                    // Step 1: Collect data from the first API (Employee Credentials)
                    var firstApiData = {
                        name: $('#name').val(),
                        email: $('#email').val(),
                        password: $('#password').val(),
                        password_confirmation: $('#password_confirmation').val(),
                        org_id: orgId 
                    };

                    console.log("First API data: ", firstApiData);

                    // Send the first API request with Bearer token
                    $.ajax({
                        url: 'https://microsols.com.au/devioo/public/api/users/store',
                        type: 'POST',
                        headers: {
                            'Authorization': 'Bearer ' + bearerToken, // Include the token here
                        },
                        data: firstApiData,
                        success: function(firstResponse) {
                            console.log("First API success response: ", firstResponse);

                            var userId = firstResponse.user
                                .id; // Assuming the response contains user ID

                            // Step 2: Collect data from the second API (Employee Profile)
                            var secondApiData = new FormData();
                            secondApiData.append('user_id', userId);
                            secondApiData.append('org_id', orgId);
                            secondApiData.append('phone', $('#phone').val());
                            secondApiData.append('address', $('#address').val());
                            secondApiData.append('cnic', $('#cnic').val());
                            secondApiData.append('gender', $('#gender').val());
                            secondApiData.append('date_of_birth', $('#date_of_birth').val());
                            secondApiData.append('image', $('#image')[0].files[
                                0]); // Collect the file input

                            console.log("Second API data: ", secondApiData);

                            // Send the second API request with Bearer token
                            $.ajax({
                                url: 'https://microsols.com.au/devioo/public/api/user/profile/store',
                                type: 'POST',
                                headers: {
                                    'Authorization': 'Bearer ' +
                                        bearerToken, // Include the token here
                                },
                                data: secondApiData,
                                contentType: false, //  for file uploads
                                processData: false, //  for file uploads
                                success: function(secondResponse) {
                                    console.log("Second API success response: ",
                                        secondResponse);

                                    var userProfileId = secondResponse.profile
                                        .id; // Assuming the response contains profile ID

                                    // Step 3: Collect data from the third API (Employee Details)
                                    var thirdApiData = {
                                        user_profile_id: userProfileId,
                                        joining_date: $('#joining_date').val(),
                                        salary_type_id: $('#salary_type_id').val(),
                                        salary_id: $('#salary_id').val(),
                                        department_id: $('#department_id').val(),
                                        designation_id: $('#designation_id').val(),
                                        allowances_id: $('#allowances_id').val(),
                                        shift_id: $('#shift_id').val(),
                                        job_type_id: $('#job_type_id').val(),
                                        education_id: $('#education_id').val(),
                                        work_history_id: $('#work_history_id')
                                            .val(),
                                            org_id: orgId 
                                    };

                                    console.log("Third API data: ", thirdApiData);

                                    // Send the third API request with Bearer token
                                    $.ajax({
                                        url: 'https://microsols.com.au/devioo/public/api/employees/store',
                                        type: 'POST',
                                        headers: {
                                            'Authorization': 'Bearer ' +
                                                bearerToken, // Include the token here
                                        },
                                        data: thirdApiData,
                                        success: function(thirdResponse) {
                                            console.log(
                                                "Third API success response: ",
                                                thirdResponse);

                                            // Final success, employee created
                                            Toastify({
                                                text: "Employee created successfully!",
                                                duration: 3000,
                                                gravity: "top",
                                                position: "right",
                                                backgroundColor: "#28a745", // Green for success
                                            }).showToast();

                                            // Optionally reset the form
                                            $('#employe_form')[0].reset();
                                            $('.btn-success').prop(
                                                'disabled', false
                                            ); // Enable submit button again

                                            // Hide the loader
                                            hideLoader();
                                            $('#image').dropify(
                                                'clearElement');
                                        },
                                        error: function(xhr) {
                                            console.log(
                                                "Third API error response: ",
                                                xhr);

                                            // Handle errors for the third API request
                                            var errors = xhr.responseJSON
                                                .errors;
                                            handleApiErrors(errors);
                                            $('.btn-success').prop(
                                                'disabled', false);
                                            hideLoader(); // Hide the loader
                                        }
                                    });

                                },
                                error: function(xhr) {
                                    console.log("Second API error response: ", xhr);

                                    // Handle errors for the second API request
                                    var errors = xhr.responseJSON.errors;
                                    handleApiErrors(errors);
                                    $('.btn-success').prop('disabled', false);
                                    hideLoader(); // Hide the loader
                                }
                            });

                        },
                        error: function(xhr) {
                            console.log("First API error response: ", xhr);

                            // Handle errors for the first API request
                            var errors = xhr.responseJSON.errors;
                            handleApiErrors(errors);
                            $('.btn-success').prop('disabled', false);
                            hideLoader(); // Hide the loader
                        }
                    });
                });

                // Function to display API errors using Toastify
                function handleApiErrors(errors) {
                    var errorMessages = '';
                    $.each(errors, function(key, value) {
                        errorMessages += value + '\n'; // Concatenate error messages
                    });

                    Toastify({
                        text: errorMessages,
                        duration: 5000,
                        gravity: "top",
                        position: "right",
                        backgroundColor: "#dc3545", // Red for error
                    }).showToast();
                }
            });
        </script>
   
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\devioo_hrm\resources\views/admin/employee/create_employee.blade.php ENDPATH**/ ?>