<?php $__env->startSection('content'); ?>
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Edit Profile
                </h3>

                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Profile
                        </li>
                    </ol>
                </nav>
            </div>


            <?php if(in_array(session('role'), ['normal', 'organization'])): ?>
                <div class="row" style="margin-left: 0; margin-right: 0;">
                    <div class="col-lg-4 col-sm-12 d-flex justify-content-center align-items-center bg-white"
                        style="height: 180px; border: 1px solid #e0e0ef; border-radius: 0.375rem;">
                        <?php if(!empty($organization['image'])): ?>
                            <img src="<?php echo e(env('API_URL_FOR_IMAGE') . '/' . $organization['image']); ?>" alt="Document Image"
                                style="max-height: 100%; max-width: 100%;">
                        <?php else: ?>
                            <h4 class="text-center">No Logo added</h4>
                        <?php endif; ?>
                    </div>

                    <div class="col-lg-8 col-sm-12 bg-white"
                        style="height: 180px; border: 1px solid #e0e0ef; border-radius: 0.375rem;">
                        <h4 class="p-3">Update Logo</h4>
                        <form id="update_logo" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="org_id" id="org_id" value="<?php echo e(session('org_id')); ?>">
                            <input type="file" name="image" class="form-control">
                            <button style="background-color: #2B2155; float: right;"
                                class="btn btn-primary float-right mt-2" type="submit">Submit</button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>


            <div class="card mt-3">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <h4>Update Password</h4>
                            <form id="update_password" class="row mt-4">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" value="<?php echo e(session('id')); ?>" name="user_id" id="user_id">
                                <div class="col-lg-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="">Password</label>
                                        <input class="form-control" type="password" name="password" id="password"
                                            placeholder="Enter Password">
                                        <small id="emailHelp" class="form-text text-muted">(min 8 characters)</small>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <div class="form-group">
                                        <label for="">Confirm Password</label>
                                        <input class="form-control" type="password" name="password_confirmation"
                                            id="password_confirmation" placeholder="Confirm Password">
                                    </div>
                                    <button style="background-color: #2B2155; float: right;"
                                        class="btn btn-primary float-right" type="submit">Submit</button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function() {
                $('#update_password').on('submit', function(e) {
                    e.preventDefault();

                    // Retrieve user ID from hidden input
                    var id = $('#user_id').val();

                    // Serialize form data
                    var formData = $(this).serialize();
                    let $submitButton = $(this).find('button[type="submit"]');

                    $submitButton.prop('disabled', true); // Disable the button during submission

                    $.ajax({
                        url: "<?php echo e(route('update_profile_password_form', ['id' => ':id'])); ?>"
                            .replace(':id', id),
                        type: 'PUT',
                        data: formData,
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response
                                    .message); // Show success message
                            } else {
                                toastr.error(response.message); // Show error message
                            }
                            $submitButton.prop('disabled',
                                false); // Re-enable the button
                        },
                        error: function(xhr) {
                            $submitButton.prop('disabled',
                                false); // Re-enable the button in case of error
                            if (xhr.status === 422) {
                                // Handle validation errors
                                var errors = xhr.responseJSON.errors;
                                // Show the first validation error
                                if (errors.password) {
                                    toastr.error(errors.password[
                                        0]); // Show first validation error
                                }
                            } else {
                                toastr.error(
                                    'Something went wrong, please try again.'); // General error
                            }
                        }
                    });
                });
                $('#update_logo').on('submit', function(e) {
                    e.preventDefault(); // Prevent the default form submission

                    // Prepare the form data
                    let formData = new FormData(this); // Use FormData to handle file upload
                    let orgId = $('#org_id').val();

                    let $submitButton = $('#update_logo button[type="submit"]');
                    $submitButton.prop('disabled', true); // Disable button to prevent multiple submissions
                    $.ajax({
                        url: "<?php echo e(route('update_organization_logo', ':id')); ?>".replace(':id',
                            orgId), // Update the route with organization ID
                        type: 'POST',
                        data: formData,
                        contentType: false, // Important for file uploads
                        processData: false, // Important for file uploads
                        headers: {
                            'Authorization': 'Bearer <?php echo e(session('bearer_token')); ?>' // Ensure you're sending the token
                        },
                        success: function(response) {
                            if (response.success) {
                                // Show a success toaster message
                                toastr.success(response.message);

                                // Refresh the page after a short delay
                                setTimeout(function() {
                                    location.reload();
                                }, 2000); // Wait 2 seconds before refreshing
                            } else {
                                // Show an error toaster message
                                toastr.error(response.message, 'Error', {
                                    timeOut: 3000
                                });
                            }
                        },
                        error: function(xhr) {
                            // Handle validation or server errors
                            let errors = xhr.responseJSON.errors;
                            if (errors) {
                                $.each(errors, function(key, value) {
                                    toastr.error(value[0], 'Error', {
                                        timeOut: 3000
                                    });
                                });
                            } else {
                                toastr.error('Something went wrong, please try again.', 'Error', {
                                    timeOut: 3000
                                });
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled',
                                false); // Re-enable the submit button after the request completes
                        }
                    });
                });

            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/admin/profile/profile.blade.php ENDPATH**/ ?>