<?php $__env->startSection('content'); ?>
    <style>
        .tab-content {
            border: none;
            position: relative;
        }

        #loader {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            /* Ensure loader appears above other content */
        }

        .tab-content form .form-group {
            margin-bottom: 20px;

        }

        .nav-tabs .nav-link.active {
            background-color: #2B2155;
            color: white;
            border-color: #2B2155;
        }

        .nav-tabs .nav-link {
            color: #2B2155;
        }

        .card {
            width: 100%;
        }

        .card-body {
            padding: 30px;
        }

        .float-right {
            margin-left: 10px;
        }

        .float-left {
            margin-right: 10px;
        }

        .select2-selection__choice {
            padding: 5px !important;
            font-size: 13px !important;
        }

        .select2-selection__rendered {
            padding: 0px 4px 5px 8px;
        }

        .select2-selection {
            padding: 2px 2px 7px 2px;
        }
    </style>


    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Create Orgnization
                </h3>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Create Orgnization
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card col-md-8 mx-auto">
                <div class="card-body" id="firstCardBody">
                    <!-- Tab Navigation -->
                    <ul class="nav nav-tabs" id="employeeTab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="credentials-tab" data-toggle="tab-disabled" href="#credentials"
                                role="tab" aria-controls="credentials" aria-selected="true">User Credentials</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="profile-tab" data-toggle="tab-disabled" href="#profile" role="tab"
                                aria-controls="profile" aria-selected="false">Organization Details</a>
                        </li>
                    </ul>
                    <div class="tab-content mt-1" id="employeeTabContent">
                        <div class="tab-pane fade show active" id="credentials" role="tabpanel"
                            aria-labelledby="credentials-tab">
                            <div id="loader" class="d-none">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <h4 class="mb-3">User Credentials</h4>
                            <form class="mt-4" id="employee_form" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div id="first_api">
                                    <div class="form-group">
                                        <label for="user_name">User Name</label>
                                        <input type="text" class="form-control" id="user_name" name="user_name"
                                            placeholder="Enter name" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            placeholder="Enter email" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="password" class="form-control" id="password" name="password"
                                            placeholder="Enter password" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">Confirm Password</label>
                                        <input type="password" class="form-control" id="password_confirmation"
                                            name="password_confirmation" placeholder="Confirm password" required>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-primary next-btn float-right"
                                    style="background-color: #2B2155;">Next</button>
                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <h4 class="mb-3">Organization Details</h4>

                            <div id="second_api" class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="organization_name">Organization Name</label>
                                        <input type="text" class="form-control" id="organization_name"
                                            name="organization_name" placeholder="Enter organization name" required>
                                    </div>
                                    <label for="permissions">Permissions</label>
                                    <select name="permissions[]" id="permissions" class="form-control select2" multiple
                                        required>
                                        <option value="all">All</option>
                                        <option value="leave_request">Leave Request</option>
                                        <option value="employee_management">Employee Management</option>
                                        <option value="finance">Finance</option>
                                        <option value="settings">Settings</option>
                                        <option value="users">Users</option>
                                    </select>
                                    <div class="form-group mt-3">
                                        <label for="currency">Currency</label>
                                        <select name="currency" id="currency" class="form-control" required>
                                            <option value="">Select Currency</option>
                                            <option value="USD">USD</option>
                                            <option value="EUR">EUR</option>
                                            <option value="GBP">GBP</option>
                                        </select>
                                    </div>
                                    <div class="form-group mt-3">
                                        <label for="image">Profile Image</label>
                                        <input type="file" class="form-control" id="image" name="image"
                                            accept="image/*">
                                    </div>
                                </div>



                            </div>
                            <button type="button" class="btn btn-secondary prev-btn float-left"
                                style="background-color: #2B2155;">Previous</button>
                            <button type="submit" class="btn btn-success float-right">Submit</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>




    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"></script>
    <!-- Include Toastify CSS and JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script>
        $('.dropify').dropify();
    </script>



    <script>
        $(".select2").select2({
            width: '100%',
        });
    </script>
    <script>
        function validateImageSize(input) {
            if (input.files && input.files[0]) {
                if (input.files[0].size > 2 * 1024 * 1024) { // 2 MB limit
                    Toastify({
                        text: "The image must be smaller than 2 MB.",
                        duration: 3000,
                        gravity: "top",
                        position: "right",
                        backgroundColor: "#e74c3c", // Red color for error
                    }).showToast();
                    input.value = ''; // Clear the input field
                }
            }
        }
        $(document).ready(function() {
            function showToastError(message) {
                Toastify({
                    text: message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: "right",
                    backgroundColor: "#ff6b6b",
                }).showToast();
            }

            function validateCredentials() {
                const username = $('#user_name').val().trim();
                const email = $('#email').val().trim();
                const password = $('#password').val().trim();
                const passwordConfirmation = $('#password_confirmation').val().trim();

                if (!username) return 'User Name is required.';
                if (!email) return 'Email is required.';
                if (!password) return 'Password is required.';
                if (password.length < 8) return 'Password must be at least 8 characters long.';
                if (!passwordConfirmation) return 'Password confirmation is required.';
                if (password !== passwordConfirmation) return 'Passwords do not match.';


                return null;
            }

            function validateProfile() {
                const orgnization_name = $('#organization_name').val().trim();
                const permissions = $('#permissions').val();
                if (!orgnization_name) return 'Organization Name is required.';
                if (!permissions) return 'Permissions is required';

                return null;
            }



            // Next button click event
            $('.next-btn').on('click', function() {
                const currentTab = $('.nav-tabs .nav-link.active').attr('id');
                let error = null;

                switch (currentTab) {
                    case 'credentials-tab':
                        error = validateCredentials();
                        break;
                    case 'profile-tab':
                        error = validateProfile();
                        break;
                }

                if (error) {
                    showToastError(error);
                } else {
                    const $activeTab = $('.nav-tabs .nav-link.active');
                    const $nextTab = $activeTab.parent().next().find('a');

                    if ($nextTab.length) {
                        $activeTab.removeClass('active').attr('aria-selected', 'false');
                        $nextTab.addClass('active').attr('aria-selected', 'true');
                        $nextTab.tab('show'); // Switch the tab

                        // Also switch the tab content
                        const nextPaneId = $nextTab.attr('href');
                        $('.tab-pane').removeClass('active show'); // Hide all content
                        $(nextPaneId).addClass('active show'); // Show the next tab's content
                    }
                }
            });

            // Previous button click event
            $('.prev-btn').on('click', function() {
                const $activeTab = $('.nav-tabs .nav-link.active');
                const $prevTab = $activeTab.parent().prev().find('a');

                if ($prevTab.length) {
                    $activeTab.removeClass('active').attr('aria-selected', 'false');
                    $prevTab.addClass('active').attr('aria-selected', 'true');
                    $prevTab.tab('show'); // Switch the tab

                    // Also switch the tab content
                    const prevPaneId = $prevTab.attr('href');
                    $('.tab-pane').removeClass('active show'); // Hide all content
                    $(prevPaneId).addClass('active show'); // Show the previous tab's content
                }
            });

            // Disable manual tab switching by preventing clicks on the tab navigation
            $('.nav-tabs a').on('click', function(e) {
                e.preventDefault();
            });

            // Form submission
            $('#employee_form').on('submit', function(e) {
                e.preventDefault();

                let $submitButton = $('#addUserForm button[type="submit"]');
                $submitButton.prop('disabled', true);

                const credentialsError = validateCredentials();
                const profileError = validateProfile();

                if (credentialsError) {
                    showToastError(credentialsError);
                    $('#credentials-tab').tab('show');
                    return;
                }

                if (profileError) {
                    showToastError(profileError);
                    $('#profile-tab').tab('show');
                    return;
                }

                const formData = new FormData(this);

                $.ajax({
                    url: "<?php echo e(route('add_organization_form')); ?>",
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    success: function(data) {
                        if (data.success) {
                            toastr.success(data.message || "Operation successful", "Success", {
                                timeOut: 3000,
                                positionClass: "toast-top-right"
                            });
                            window.location.href =
                                '<?php echo e(route('organization_list')); ?>';
                        } else {
                            handleErrors(data.errors, data.message);
                        }
                    },
                    error: function(xhr) {
                        let response = xhr.responseJSON;

                        // Check if it's a validation error
                        if (xhr.status === 422 && response.errors) {
                            let errorMessages = [];
                            for (let field in response.errors) {
                                if (response.errors.hasOwnProperty(field)) {
                                    errorMessages.push(...response.errors[
                                        field]); // Collect all error messages
                                }
                            }

                            // Display the collected error messages
                            if (errorMessages.length > 0) {
                                toastr.error(errorMessages.join('<br>'), "Validation Error", {
                                    timeOut: 3000,
                                    positionClass: "toast-top-right"
                                });
                            } else {
                                toastr.error(response.message || 'An error occurred.',
                                    "Error", {
                                        timeOut: 3000,
                                        positionClass: "toast-top-right"
                                    });
                            }
                        } else {
                            toastr.error(response.message ||
                                'An error occurred while adding the organization.',
                                "Error", {
                                    timeOut: 3000,
                                    positionClass: "toast-top-right"
                                });
                        }
                    },
                    complete: function() {
                        $submitButton.prop('disabled',
                            false); // Re-enable the submit button after the request completes
                    }
                });

                function handleErrors(errors, generalMessage) {
                    if (errors && typeof errors === 'object') {
                        Object.values(errors).flat().forEach(showToastError);
                    } else {
                        showToastError(generalMessage || 'An unexpected error occurred');
                    }
                }

                function showToastError(message) {
                    toastr.error(message, "Error", {
                        timeOut: 3000,
                        positionClass: "toast-top-right"
                    });
                }
            });






        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/microsolscom/public_html/devioo-hrm/resources/views/super_admin/organization/create_organization.blade.php ENDPATH**/ ?>