<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bonus extends Model
{
    use HasFactory;

    protected $table = 'bonuses';

    protected $fillable = [
        'org_id',
        'employee_id',
        'amount',
        'date',
        'reason',
        'status',
    ];

  
    public function organization()
    {
        return $this->belongsTo(Organization::class, 'org_id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
