<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deducation extends Model
{
    use HasFactory;
    protected $table = 'deducations';

    // Define which attributes are mass assignable
    protected $fillable = [
        'employee_id',
        'amount',
        'date',
        'reason',
        'status',
        'org_id'
    ];

    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
