<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PettyCash extends Model
{
    use HasFactory;

    protected $table = 'petty_cashes';

    protected $fillable = [
        'employee_id',
        'amount',
        'date',
        'description',
    ];

    // Relationships

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
