<?php

namespace App\Models\Settings;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model
{
    use HasFactory;

    protected $table = 'user_profiles';
    
    protected $fillable = [
        'image',
        'phone',
        'address',
        'cnic',
        'date_of_birth',
        'gender',
        'user_id',
        'org_id',
    ];

    // protected $hidden = [
    //     'created_at',
    //     'updated_at',
    // ];

    public function employees()
    {
        return $this->hasMany(Employee::class, 'user_profile_id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User::class, 'user_id');
    }

}
