<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document Expiration Reminder</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #2c3e50;
        }
        p {
            line-height: 1.6;
        }
        .footer {
            margin-top: 20px;
            font-size: 12px;
            color: #888;
        }
        .button {
            display: inline-block;
            padding: 10px 15px;
            margin-top: 20px;
            color: #fff;
            background-color: #3498db;
            text-decoration: none;
            border-radius: 5px;
        }
        .button:hover {
            background-color: #2980b9;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Document Expiration Reminder</h1>
        <p>Dear [Recipient's Name],</p>
        <p>This is a friendly reminder that your document <strong>"{{ $document->name }}"</strong> is set to expire on <strong>{{ $document->remind_date }}</strong>.</p>
        <p>Please take the necessary actions to renew or update your document before the expiration date to avoid any disruptions.</p>
        <a href="{{ $document->link }}" class="button">View Document</a>
        <p>If you have any questions, feel free to reach out to us.</p>
        <p>Best regards,<br>Your Company Name</p>
        <div class="footer">
            <p>This email was sent to [recipient@example.com]. If you would like to unsubscribe, click <a href="#">here</a>.</p>
        </div>
    </div>
</body>
</html>
    