<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\SettingsController;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\BonusController;
use App\Http\Controllers\Api\EmployeeController;
use App\Http\Controllers\Api\UserProfileController;
use App\Http\Controllers\Api\IncrementController;
use App\Http\Controllers\Api\DeducationController;
use App\Http\Controllers\Api\DocumentController;
use App\Http\Controllers\Api\IncomeController;
use App\Http\Controllers\Api\LeaveController;
use App\Http\Controllers\Api\LeaveTypeController;
use App\Http\Controllers\Api\LoanController;
use App\Http\Controllers\Api\OrganizationController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\PettyCashController;
use App\Http\Controllers\Api\TaxSlabController;
use App\Http\Controllers\FileChangeController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/file-change', [FileChangeController::class, 'handleFileChange']);
Route::middleware('auth:sanctum')->group(function () {

    Route::post('/logout', [AuthController::class, 'logout']);
    
    Route::get('/dashboard',[AuthController::class,'dashboard']);
    Route::get('/dashboard/reminders',[AuthController::class,'reminders']);

    Route::post('/update/status', [AuthController::class, 'updateStatus']);

    //UserController
    Route::get('users', [UserController::class, 'user_list']);
    Route::get('users/index', [UserController::class, 'user_list_index']);
    Route::get('users/permissions', [UserController::class, 'get_assigned_permission_user']);
    Route::get('users/permissions/index', [UserController::class, 'get_assigned_permission_user_index']);
    Route::get('users/get/{id}', [UserController::class, 'get_user']);
    Route::post('users/store', [UserController::class, 'add_user_form']);
    Route::put('users/update/{id}', [UserController::class, 'update_user_form']);
    Route::delete('users/{id}', [UserController::class, 'delete_user']);
    Route::post('users/password/reset/email', [UserController::class, 'sendResetLinkEmail']);
    Route::post('users/password/reset', [UserController::class, 'reset']);
   
   
    //department
    Route::get('departments', [SettingsController::class, 'department_list']);
    Route::get('departments/index', [SettingsController::class, 'department_index']);
    Route::get('departments/get/{id}', [SettingsController::class, 'get_department']);
    Route::post('departments/store', [SettingsController::class, 'add_department_form']);
    Route::put('departments/update/{id}', [SettingsController::class, 'update_department_form']);
    Route::delete('departments/{id}', [SettingsController::class, 'delete_department']);
    
    //designation
    Route::get('designations', [SettingsController::class, 'designation_list']);
    Route::get('designations/index', [SettingsController::class, 'designation_index']);
    Route::get('designations/get/{id}', [SettingsController::class, 'get_designation']);
    Route::post('designations/store', [SettingsController::class, 'add_designation_form']);
    Route::put('designations/update/{id}', [SettingsController::class, 'update_designation_form']);
    Route::delete('designations/{id}', [SettingsController::class, 'delete_designation']);
  
    //allowances
    Route::get('allowances', [SettingsController::class, 'allowances_list']);
    Route::get('allowances/index', [SettingsController::class, 'allowances_index']);
    Route::get('allowances/get/{id}', [SettingsController::class, 'get_allowances']);
    Route::post('allowances/store', [SettingsController::class, 'add_allowances_form']);
    Route::put('allowances/update/{id}', [SettingsController::class, 'update_allowances_form']);
    Route::delete('allowances/{id}', [SettingsController::class, 'delete_allowances']);
   
    //job_type
    Route::get('job_types/index', [SettingsController::class, 'job_type_index']);
    Route::get('job_types', [SettingsController::class, 'job_type_list']);
    Route::get('job_types/get/{id}', [SettingsController::class, 'get_job_type']);
    Route::post('job_types/store', [SettingsController::class, 'add_job_type_form']);
    Route::put('job_types/update/{id}', [SettingsController::class, 'update_job_type_form']);
    Route::delete('job_types/{id}', [SettingsController::class, 'delete_job_type']);
   
    //work_history
    Route::get('work_history', [SettingsController::class, 'work_history_list']);
    Route::get('work_history/get/{id}', [SettingsController::class, 'get_work_history']);
    Route::post('work_history/store', [SettingsController::class, 'add_work_history_form']);
    Route::put('work_history/update/{id}', [SettingsController::class, 'update_work_history_form']);
    Route::delete('work_history/{id}', [SettingsController::class, 'delete_work_history']);
    
    
    //education
    Route::get('education', [SettingsController::class, 'education_list']);
    Route::get('education/get/{id}', [SettingsController::class, 'get_education']);
    Route::post('education/store', [SettingsController::class, 'add_education_form']);
    Route::post('education/update/{id}', [SettingsController::class, 'update_education_form']);
    Route::delete('education/{id}', [SettingsController::class, 'delete_education']);
    
    //shift
    Route::get('shift', [SettingsController::class, 'shift_list']);
    Route::get('shift/index', [SettingsController::class, 'shift_index']);
    Route::get('shift/get/{id}', [SettingsController::class, 'get_shift']);
    Route::post('shift/store', [SettingsController::class, 'add_shift_form']);
    Route::put('shift/update/{id}', [SettingsController::class, 'update_shift_form']);
    Route::delete('shift/{id}', [SettingsController::class, 'delete_shift']);
 
    //salary
    // Route::get('salary', [SettingsController::class, 'salary_list']);
    // Route::get('salary/get/{id}', [SettingsController::class, 'get_salary']);
    // Route::post('salary/store', [SettingsController::class, 'add_salary_form']);
    // Route::put('salary/update/{id}', [SettingsController::class, 'update_salary_form']);
    // Route::delete('salary/{id}', [SettingsController::class, 'delete_salary']);
  
    //salary_type
    Route::get('salary_type/index', [SettingsController::class, 'salary_type_index']);
    Route::get('salary_type', [SettingsController::class, 'salary_type_list']);
    Route::get('salary_type/get/{id}', [SettingsController::class, 'get_salary_type']);
    Route::post('salary_type/store', [SettingsController::class, 'add_salary_type_form']);
    Route::put('salary_type/update/{id}', [SettingsController::class, 'update_salary_type_form']);
    Route::delete('salary_type/{id}', [SettingsController::class, 'delete_salary_type']);

    // Employee
    Route::get('employees', [EmployeeController::class, 'get_employees']);
    Route::get('employees/index', [EmployeeController::class, 'get_employees_index']);
    Route::get('employees/{id}', [EmployeeController::class, 'get_employee']);
    Route::post('employees/store', [EmployeeController::class, 'add_employee']);
    Route::post('employees/update/{id}', [EmployeeController::class, 'update_employee']);
    Route::delete('employees/{id}', [EmployeeController::class, 'delete_employee']);
    Route::post('/process/csv/payslips', [EmployeeController::class, 'process_csv_and_store_payslips']);

    //Payslip
    Route::get('/payslip/{id}', [EmployeeController::class, 'get_payslip']); 
    Route::get('/get/report', [EmployeeController::class, 'get_report']); 
    Route::get('/get/report/income', [EmployeeController::class, 'income_report']); 
    Route::get('/get/report/payment/{id}', [EmployeeController::class, 'get_payment']); 

    // user_profiles
    Route::get('user/profile', [UserProfileController::class, 'get_profiles']);
    Route::get('user/profile/{id}', [UserProfileController::class, 'get_profile']);
    Route::post('user/profile/store', [UserProfileController::class, 'add_profile']);
    Route::post('user/profile/update/{id}', [UserProfileController::class, 'update_profile']);
    Route::delete('user/profile/{id}', [UserProfileController::class, 'delete_profile']);  

    //IncrementController
    Route::get('increments/index', [IncrementController::class, 'get_increments_index']);
    Route::get('increments/', [IncrementController::class, 'get_increments']);
    Route::post('increments/store', [IncrementController::class, 'add_increment']);
    Route::get('increments/get/{id}', [IncrementController::class, 'get_increment']);
    Route::put('increments/update/{id}', [IncrementController::class, 'update_increment']);
    Route::delete('increments/{id}', [IncrementController::class, 'delete_increment']);

    //DeducationController
    Route::get('/deductions', [DeducationController::class, 'get_deductions']);
    Route::get('/deductions/index', [DeducationController::class, 'get_deductions_index']);
    Route::post('/deductions/store', [DeducationController::class, 'add_deduction']);
    Route::get('/deductions/get/{id}', [DeducationController::class, 'get_deduction']);
    Route::put('/deductions/update/{id}', [DeducationController::class, 'update_deduction']);
    Route::delete('/deductions/{id}', [DeducationController::class, 'delete_deduction']);

    //LoanController
    Route::get('loans/index', [LoanController::class, 'get_loans_index']);
    Route::get('/loans', [LoanController::class, 'get_loans']);
    Route::post('/loans/store', [LoanController::class, 'add_loan']);
    Route::get('/loans/get/{id}', [LoanController::class, 'get_loan']);
    Route::put('/loans/update/{id}', [LoanController::class, 'update_loan']);
    Route::delete('/loans/{id}', [LoanController::class, 'delete_loan']);
    
    //TaxSlabController
    Route::get('/tax/slabs', [TaxSlabController::class, 'get_tax_slabs']);
    Route::get('/tax/slabs/index', [TaxSlabController::class, 'get_tax_slabs_index']);
    Route::post('/tax/slabs/store', [TaxSlabController::class, 'add_tax_slab']);
    Route::get('/tax/slabs/get/{id}', [TaxSlabController::class, 'get_tax_slab']);
    Route::put('/tax/slabs/update/{id}', [TaxSlabController::class, 'update_tax_slab']);
    Route::delete('/tax/slabs/{id}', [TaxSlabController::class, 'delete_tax_slab']);

    //IncomeController
    Route::get('/incomes', [IncomeController::class, 'get_incomes']);
    Route::post('/incomes/store', [IncomeController::class, 'add_income']);
    Route::get('/incomes/get/{id}', [IncomeController::class, 'get_income']);
    Route::put('/incomes/update/{id}', [IncomeController::class, 'update_income']);
    Route::delete('/incomes/{id}', [IncomeController::class, 'delete_income']);
    Route::get('/incomes/search', [IncomeController::class, 'search_by_type']);
    Route::get('/incomes/search/index', [IncomeController::class, 'search_incomes_index']);

    //DocumentController
    Route::get('documents', [DocumentController::class, 'get_documents']);
    Route::get('/documents/index', [DocumentController::class, 'get_documents_index']);
    Route::post('documents/store', [DocumentController::class, 'add_document']);
    Route::get('documents/get/{id}', [DocumentController::class, 'get_document']);
    Route::post('documents/update/{id}', [DocumentController::class, 'update_document']);
    Route::delete('documents/{id}', [DocumentController::class, 'delete_document']);

    //OrganizationController
    Route::get('organizations', [OrganizationController::class, 'get_organizations']);
    Route::get('organizations/index', [OrganizationController::class, 'get_organizations_index']);
    Route::post('organizations/store', [OrganizationController::class, 'add_organization']);
    Route::get('organizations/get/{id}', [OrganizationController::class, 'get_organization']);
    Route::post('organizations/update/{id}', [OrganizationController::class, 'update_organization']);
    Route::delete('organizations/{id}', [OrganizationController::class, 'delete_organization']);

    //BonusController 
    Route::get('bonuses', [BonusController::class, 'get_bonuses']);
    Route::get('bonuses/index', [BonusController::class, 'get_bonuses_index']);
    Route::post('bonuses/store', [BonusController::class, 'add_bonus']);
    Route::get('bonuses/get/{id}', [BonusController::class, 'get_bonus']);
    Route::put('bonuses/update/{id}', [BonusController::class, 'update_bonus']);
    Route::delete('bonuses/{id}', [BonusController::class, 'delete_bonus']);
    
    // LeaveTypeController
    Route::get('/leave/types', [LeaveTypeController::class, 'get_leave_types']);
    Route::get('/leave/types/index', [LeaveTypeController::class, 'get_leave_types_index']);
    Route::post('/leave/types/store', [LeaveTypeController::class, 'add_leave_type']);
    Route::get('/leave/types/get/{id}', [LeaveTypeController::class, 'get_leave_type']);
    Route::put('/leave/types/update/{id}', [LeaveTypeController::class, 'update_leave_type']);
    Route::delete('/leave/types/{id}', [LeaveTypeController::class, 'delete_leave_type']);
    
    //LeaveController
    Route::get('/leaves', [LeaveController::class, 'get_leaves']);
    Route::get('/leaves/index', [LeaveController::class, 'get_leaves_index']);
    Route::post('/leaves/store', [LeaveController::class, 'add_leave']);
    Route::get('/leaves/get/{id}', [LeaveController::class, 'get_leave']);
    Route::put('/leaves/update/{id}', [LeaveController::class, 'update_leave']);
    Route::delete('/leaves/{id}', [LeaveController::class, 'delete_leave']);
    Route::get('user/leaves/{user_id}', [LeaveController::class, 'get_user_leaves']);
    
    //PaymentController
    Route::get('/payments', [PaymentController::class, 'get_payments']);
    Route::post('/payments/store', [PaymentController::class, 'add_payment']);
    Route::get('/payments/get/{id}', [PaymentController::class, 'get_payment']);
    Route::put('/payments/update/{id}', [PaymentController::class, 'update_payment']);
    Route::delete('/payments/{id}', [PaymentController::class, 'delete_payment']);

    Route::get('/petty/cashes', [PettyCashController::class, 'index']);
    Route::post('/petty/cashes', [PettyCashController::class, 'store']);
    Route::get('/petty/cashes/{id}', [PettyCashController::class, 'show']);
    Route::put('/petty/cashes/{id}', [PettyCashController::class, 'update']);
    Route::delete('/petty/cashes/{id}', [PettyCashController::class, 'destroy']);

    Route::get('export-payments', [PaymentController::class, 'exportPayments']);

Route::get('/temporary-pdf-link', [FileChangeController::class, 'generateTemporaryPdfLink'])->name('google.docs.download');

// Callback route for Google OAuth
Route::get('/oauth-callback', [FileChangeController::class, 'oauthCallback'])->name('google.oauth.callback');

});
Route::get('download/{file}', [PaymentController::class, 'download'])->name('download');
