<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\DataTables\Settings\AllowanceDataTable;

class AllowanceController extends Controller
{
    public function allowance_list(AllowanceDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.allowance');
    }
    public function add_allowance_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $org_id = session('org_id');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/allowances/store", [
                'org_id' => $org_id,
                'name' => $request->name,
                'amount' => $request->amount,
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Allowance added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Allowance.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_allowance_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the allowance
            $response = Http::withToken($token)->put("{$apiBaseUrl}/allowances/update/{$id}", [
                'name' => $request->name,
                'amount' => $request->amount,
                'status' => 'active',
            ]);
        //    dd($response->json());
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Allowance updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Allowance.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_allowance($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/allowances/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Allowance deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Allowance'
            ], $response->status());
        }
    }

    public function get_allowance($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/allowances/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the allowance data from the API response
                return response()->json($response->json()['allowance']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Allowance not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
