<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\DataTables\Settings\SalaryTypeDataTable;

class SalaryTypeController extends Controller
{
    public function salary_type_list(SalaryTypeDataTable $dataTable)
    {
        return $dataTable->render('admin.settings.salary_type');
    }
    public function add_salary_type_form(Request $request)
    {
       
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $org_id = session('org_id');
            $response = Http::withToken($token)->post("{$apiBaseUrl}/salary_type/store", [
                'salary_type' => $request->salary_type,
                'org_id' => $org_id
            ]);
    
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Salary Type added successfully']);
            } else {
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to add Salary Type.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    public function update_salary_type_form(Request $request, $id)
    {
        try {
            // Get the token from session and set the base API URL
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
    
            // Send a PUT request to update the education
            $response = Http::withToken($token)->put("{$apiBaseUrl}/salary_type/update/{$id}", [
                'salary_type' => $request->salary_type,
            ]);
    
            // Check if the response is successful
            if ($response->successful()) {
                return response()->json(['success' => true, 'message' => 'Salary Type updated successfully']);
            } else {
                // If the response contains an error, extract the error message
                $error = $response->json();
                return response()->json([
                    'success' => false,
                    'message' => $error['message'] ?? 'Failed to update Salary Type.'
                ], $response->status());
            }
        } catch (\Exception $e) {
            // Handle general exceptions
            return response()->json(['success' => false, 'message' => 'Something went wrong: ' . $e->getMessage()], 500);
        }
    }
    
    
    public function delete_salary_type($id)
    {
        $token = session('bearer_token');
        $apiBaseUrl = env('API_BASE_URL');
        $response = Http::withToken($token)->delete("{$apiBaseUrl}/salary_type/{$id}");

        if ($response->successful()) {
            return response()->json(['success' => true, 'message' => 'Salary Type deleted successfully']);
        } else {
            // Ensure the error message is correctly fetched from the API response
            $error = $response->json();
            return response()->json([
                'success' => false,
                'message' => $error['message'] ?? 'Unable to delete Salary Type'
            ], $response->status());
        }
    }

    public function get_salary_type($id)
    {
        try {
            $token = session('bearer_token');
            $apiBaseUrl = env('API_BASE_URL');
            $response = Http::withToken($token)->get("{$apiBaseUrl}/salary_type/get/{$id}");
    
          
    
            if ($response->successful()) {
                // Return the education data from the API response
                return response()->json($response->json()['salary_type']);
            } else {
                return response()->json(['status' => 404, 'message' => 'Salary Type not found.'], 404);
            }
        } catch (\Exception $e) {
            // Dump the exception message and die
            dd('An error occurred: ' . $e->getMessage());
            return response()->json(['message' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
}
