
@extends('admin.layout.main')
@section('content')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
    
        @media print {
        /* Hide everything except the .PrintBody */
        body * {
            visibility: hidden;
        }
    
        .PrintBody, .PrintBody * {
            visibility: visible;
        }
    
        /* Ensure that .PrintBody is positioned at the top */
        .PrintBody {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
        }
    }
    
    </style>
    <script>
        $(document).ready(function() {
            $("#payment").click(function() {
                $('#PayBtn').hide();
                var printableSectionClone = $(".PrintBody").clone();

                // Remove script tags from the cloned section
                printableSectionClone.find('script').remove();
                var printContainer = $("<div>").append(printableSectionClone);

                $("body").children().not(printContainer).hide(); // Hides all except the printContainer
                $("body").append(printContainer);

                window.print();

                printContainer.remove();
                $("body").children().show(); // Shows all after print
                $('#PayBtn').show();
            });
        });
    </script>

    <div class="content-wrapper">
        <div class="row page-header">
            <h3 class="col-md-6 page-title">Salary List</h3>
            <nav class="col-md-6 text-right" aria-label="breadcrumb">
                <a href="{{ route('employees_index') }}" class="btn btn-sm btn-outline-primary">
                    <i class="fa fa-list mr-sm-2"></i>Employees List
                </a>
            </nav>
            <nav class="col-12" aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Pay Slip</li>
                </ol>
            </nav>
        </div>
        <div class="container">
            <div class="card p-5">
                <div class="d-flex justify-content-end">
                    <a id="payment" class="btn bg-danger text-white" target="_blank">Print <i
                            class="fas fa-print"></i></a>
                </div>
                <div class="row PrintBody">
                    <div class="col-md-12">
                        <div class="text-center">
                            <img src="{{ session('logo') ? session('logo') : asset('assets/images/hexon-logo.png') }}" alt="Hexon Logo"
                            style="width: 100%; max-width:250px;">
                        </div>
                        <div class="mb-2 mt-3 text-center">
                            <h3 class="fw-bold">Payslip</h3>
                            <span class="fw-normal">Payment slip for the month of {{ $data['salary_month'] }}</span>
                        </div>
                        <div>
                            <h3 class="text-uppercase">{{ $data['employee']['user_profile']['user']['name'] }}</h3>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Email :</span>
                                    <small class="ms-3">{{ $data['employee']['user_profile']['user']['email'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Phone :</span>
                                    <small class="ms-3">{{ $data['employee']['user_profile']['phone'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">CNIC :</span>
                                    <small class="ms-3">{{ $data['employee']['user_profile']['cnic'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Gender :</span>
                                    <small
                                        class="text-capitalize ms-3">{{ $data['employee']['user_profile']['gender'] }}</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Department :</span>
                                    <small
                                        class="text-capitalize ms-3">{{ $data['employee']['department']['department'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Designation :</span>
                                    <small
                                        class="text-capitalize ms-3">{{ $data['employee']['designation']['designation'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Shift :</span>
                                    <small class="text-capitalize ms-3">{{ $data['employee']['shift']['shift'] }}</small>
                                </div>
                                <div>
                                    <span class="fw-bolder w-25 d-inline-block">Duty Time :</span>
                                    <small class="ms-3">9:00 Hr</small>
                                </div>
                            </div>
                        </div>

                        <table class="table-bordered mt-4 table">
                            <thead class="bg-danger text-white">
                                <tr>
                                    <th scope="col">Earnings</th>
                                    <th scope="col">Amount</th>
                                    <th class="text-dark bg-white text-center">-</th>
                                    <th scope="col">Deductions</th>
                                    <th scope="col">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Basic Salary</td>
                                    <td>Rs {{ number_format($data['salary'], 2) }} -/<sub>only</sub></td>
                                    <td class="text-center">-</td>
                                    <td>Deductions</td>
                                    <td>Rs {{ number_format($data['deductions'], 2) }} -/<sub>only</sub></td>
                                </tr>
                                <tr>
                                    <td>Bonus</td>
                                    <td>Rs {{ number_format($data['bonus_amount'], 2) }} -/<sub>only</sub></td>
                                    <td class="text-center">-</td>
                                    <td>Installment</td>
                                    <td>Rs {{ number_format($data['loan_installment'], 2) }} -/<sub>only</sub></td>
                                </tr>
                                <tr>
                                    <td>Increment</td>
                                    <td>Rs {{ number_format($data['increments'], 2) }} -/<sub>only</sub></td>
                                    <td class="text-center">-</td>
                                    <td>Tax</td>
                                    <td>Rs {{ number_format($data['tax'], 2) }} -/<sub>only</sub></td>


                                </tr>
                                <tr>
                                    <td>Allowance</td>
                                    <td>Rs {{ number_format($data['allowances'], 2) }} -/<sub>only</sub></td>
                                    <td class="text-center">-</td>
                                    <td>Leave Deduction</td>
                                    <td>Rs {{ number_format($data['leave_deduction'], 2) }} -/<sub>only</sub></td>
                                </tr>
                                <tr class="border-top">
                                    <th>Total Earning</th>
                                    <td>
                                        @if (!isset($data['total_earning']))
                                        @php
                                            $totalEarning = 
                                                ($data['allowances'] ?? 0) + 
                                                ($data['increments'] ?? 0) + 
                                                ($data['salary'] ?? 0) + 
                                                ($data['bonus_amount'] ?? 0);
                                        @endphp
                                        Rs {{ number_format($totalEarning, 2) }} -/<sub>only</sub>
                                        @else
                                            Rs {{ number_format($data['total_earning'], 2) }} -/<sub>only</sub>
                                        @endif
                                    
                                        
                                    </td>
                                    <td class="text-center">-</td>
                                    <th>Total Deductions</th>
                                  
                                    <td>
                                        @if (!isset($data['total_deduction']))
                                            @php
                                                $totalDeduction =
                                                    ($data['tax'] ?? 0) +
                                                    ($data['loan_installment'] ?? 0) +
                                                    ($data['deductions'] ?? 0) +
                                                    ($data['leave_deduction'] ?? 0);
                                            @endphp
                                            Rs {{ number_format($totalDeduction, 2) }} -/<sub>only</sub>
                                        @else
                                            Rs {{ number_format($data['total_deduction'], 2) }} -/<sub>only</sub>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <div class="row mb-3 mt-4">
                            <div class="col-md-6">
                                <div class="font-weight-bold p-2" style="font-size:20px;">
                                    <span>Net Salary : </span>
                                    <td>Rs {{ number_format($data['net_pay_after_tax'], 2) }} -/<sub>only</sub></td>
                                </div>
                            </div>
                            <div class="col-md-6 text-right">
                                <div class="border-bottom p-2 text-left">
                                    <span>Authorised Signatory : </span>
                                </div>
                            </div>
                            <div class="col-md-12 font-weight-bold text-capitalize mt-4 text-center">
                                <span>In Words : </span>{{ $data['total_amount_in_words'] }} <sub>-/Rupees Only</sub>

                            </div>
                            <div class="col-md-12 font-weight-bold text-capitalize mt-4 text-left">
                                <span>Salary Comment :</span> <br>
                                <p class="fw-lighter">{{ $data['salary_comment'] }}</p>

                            </div>
                        </div>
                        <div>


                            <form method="POST" action="{{ route('pay_salary') }}">
                                @csrf
                                <input type="hidden" name="employee_id" value="{{ $data['employee']['id'] }} ">
                                <input type="hidden" name="increments" value="{{ $data['increments'] ?? 0 }}">
                                <input type="hidden" name="deductions" value="{{ $data['deductions'] ?? 0 }}">
                                <input type="hidden" name="loan_amount" value="{{ $data['loan_amount'] ?? 0 }}">
                                <input type="hidden" name="leave_deduction" value="{{ $data['leave_deduction'] ?? 0 }}">
                                <input type="hidden" name="unpaid_leaves" value="{{ $data['unpaid_leaves'] ?? 0 }}">
                                <input type="hidden" name="salary" value="{{ $data['salary'] ?? 0 }}">
                                <input type="hidden" name="salary_comment" value="{{ $data['salary_comment'] ?? '' }}">
                                <input type="hidden" name="loan_installment" value="{{ $data['loan_installment'] ?? 0 }}">
                                <input type="hidden" name="allowances" value="{{ $data['allowances'] ?? 0 }}">
                                <input type="hidden" name="bonus_amount" value="{{ $data['bonus_amount'] ?? 0 }}">
                                <input type="hidden" name="net_pay" value="{{ $data['net_pay'] ?? 0 }}">
                                <input type="hidden" name="tax" value="{{ $data['tax'] ?? 0 }}">
                                <input type="hidden" name="loan_id" value="{{ $data['loan_id'] ?? 0 }}">
                                <input type="hidden" name="net_pay_after_tax"
                                    value="{{ $data['net_pay_after_tax'] ?? 0 }}">
                                <input type="hidden" name="salary_month" value="{{ $salary_date ?? 0 }}">

                                <div class="d-flex justify-content-end">
                                    @if ($data['payment_status'] === 'paid')
                                        <!-- Display this image if the payment status is 'paid' -->
                                        <img src="https://media.istockphoto.com/id/477525839/photo/paid-red-rubber-stamp.jpg?s=612x612&w=0&k=20&c=kqGK7Dgs6kIFszHhPfyMOJa0OPtKnOwd2cLPiQHq53w="
                                            alt="Paid" style="height: 100px;">
                                    @else
                                        <input type="submit" class="btn bg-danger text-white" value="Pay Now !!">
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    </div>
@endsection
