<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <title>Hexon Digital HRM</title>
    <link rel="stylesheet" href="{{ asset('assets/vendors/iconfonts/font-awesome/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/css/vendor.bundle.base.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/css/vendor.bundle.addons.css') }}">
    <link rel="stylesheet" href="{{ asset('assets\vendors\iconfonts\simple-line-icon\css\simple-line-icons.css') }}">


    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link rel="shortcut icon" href="{{ asset('assets/images/logo-mini.png') }}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.12/summernote-lite.css">
    <link href="{{ url('/assets/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" />
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    @stack('header')
    <style>
        .sidebar .nav .nav-item.active>.nav-link i,
        .sidebar .nav .nav-item.active>.nav-link .menu-title,
        .sidebar .nav .nav-item.active>.nav-link .menu-arrow {
            color: #E11C44 !important;
        }

        .sidebar .nav .nav-item.active>.nav-link:before {
            background: #E11C44 !important;
        }

        /* Set scrollbar width */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background-color: lightgrey;
        }

        ::-webkit-scrollbar-thumb {
            background-color: grey;
        }

        ::-webkit-scrollbar-thumb {
            border-radius: 6px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background-color: darkgrey;
        }

        hr {
            margin-top: .25rem;
            margin-bottom: .25rem;
        }

        .jq-toast-single {
            display: none !important;
        }

        .dropify-wrapper {
            height: 110px !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 40px !important;
        }

        .swal2-icon {
            margin-top: 1rem !important;
        }


        /* SCROLL */
        .sidebar {
            height: 100%;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background-color: #c2b9b9;
            border-radius: 6px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background-color: #555;
        }

        .sidebar::-webkit-scrollbar-thumb:active {
            background-color: #333;
        }

        .sidebar::-webkit-scrollbar-track {
            background-color: #f1f1f1;
        }

        .sidebar::-webkit-scrollbar-corner {
            background-color: #f1f1f1;
        }

        /* Hide number input arrows (spinners) in Chrome, Safari, Edge */
        input[type="number"]::-webkit-outer-spin-button,
        input[type="number"]::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        #info_section {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            padding: 10px;
        }

        #info_section #info_user_name {
            margin: 0;
            font-weight: bold;
            font-size: 16px;
            text-transform: capitalize
        }

        #info_section #info_designation {
            color: gray;
            font-size: 14px;
        }
    </style>



    <nav class="navbar col-lg-12 col-12 fixed-top d-flex default-layout-navbar flex-row p-0" id="no-print">
        <div class="navbar-brand-wrapper d-flex align-items-center justify-content-center text-center">

            <a class="navbar-brand brand-logo" href="#">
                <img src="{{ session('logo') ? session('logo') : asset('assets/images/logo-beta.png') }}" alt="logo"
                    style="max-width: fit-content" />
            </a>

            <a class="navbar-brand brand-logo-mini" href="#">
                <img src="{{ asset('assets/images/logo-mini.png') }}" alt="logo" />
            </a>

        </div>
        <div class="navbar-menu-wrapper d-flex align-items-stretch">
            <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
                <span class="fas fa-bars"></span>
            </button>

            <ul class="navbar-nav navbar-nav-right">
                
                <li class="nav-item" id="info_section">
                    <div class="profile-info">
                        <p id="info_user_name">{{ session('user_name') ?? '' }}</p>
                        <h5 id="info_designation">{{ session('designation') ?? '' }}</h5>
                    </div>
                </li>

                <li class="nav-item nav-profile">
                    <a class="nav-link"
                        @if (in_array(session('role'), ['normal', 'organization', 'admin'])) href="{{ route('profile') }}" 
                        @elseif(session('role') === 'employee') 
                        href="{{ route('employee_profile') }}" 
                        @else
                        href="#" @endif>
                        <img src="https://img.freepik.com/free-vector/businessman-character-avatar-isolated_24877-60111.jpg?size=626&ext=jpg&ga=GA1.1.117950178.1705401509&semt=ais_hybrid"
                            alt="Profile Image" title="Profile">
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                    <a class="nav-link" href="#" title="Logout"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt text-danger mx-0 mt-1 text-white" style="font-size:22px"></i>

                    </a>
                </li>
            </ul>

            <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center text-end" type="button"
                data-toggle="offcanvas">
                <span class="fas fa-bars"></span>
            </button>
        </div>
    </nav>

    <div class="container-fluid page-body-wrapper">
        <nav class="sidebar sidebar-offcanvas" id="sidebar">
            <ul class="nav">

                @php
                    $permissions = session('permissions', []);

                @endphp
                <li class="nav-item">
                    <a class="nav-link" href="{{ url('/') }}">
                        <i class="fa fa-home menu-icon"></i>
                        <span class="menu-title">Dashboard</span>
                    </a>
                </li>
                @if (session('role') === 'employee')
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('leave_list') }}">
                            <i class="fab fa-pied-piper-alt menu-icon"></i>
                            <span class="menu-title">Leave Request</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('employee_expense_request') }}">
                            <i class="fab fa-pied-piper-alt menu-icon"></i>
                            <span class="menu-title">Expense Request</span>
                        </a>
                    </li>
                @endif
                @if (session('role') === 'admin')
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('organization_list') }}">
                            <i class="fa fa-sitemap menu-icon"></i>
                            <span class="menu-title">Organizations</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('admin_list') }}">
                            <i class="fa fa-users menu-icon"></i>
                            <span class="menu-title">Manage Users</span>
                        </a>
                    </li>
                @endif
                @if (in_array(session('role'), ['normal', 'organization', 'employee']))
                    @if (hasPermission('users', $permissions))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('user_list') }}">
                                <i class="fa fa-user menu-icon"></i>
                                <span class="menu-title">Users</span>
                            </a>
                        </li>
                    @endif

                    @if (hasPermission('employee', $permissions))
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="collapse" href="#page-employee" aria-expanded="false"
                                aria-controls="page-employee">
                                <i class="fa fa-users menu-icon"></i>
                                <span class="menu-title">Employee </span>
                                <i class="menu-arrow"></i>
                            </a>
                            <div class="collapse" id="page-employee">
                                <ul class="nav flex-column sub-menu">
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('employees_index') }}">
                                            Employee Profile
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('document_list') }}">
                                            Document
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('department_list') }}">
                                <i class="far fa-building menu-icon"></i>
                                <span class="menu-title">Departments</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('designation_list') }}">
                                <i class="fas fa-fill-drip menu-icon"></i>
                                <span class="menu-title">Designation</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('shift_list') }}">
                                <i class="fa fa-cubes menu-icon"></i>
                                <span class="menu-title">Shift</span>
                            </a>
                        </li>
                    @endif





                    @if (hasPermission('leave_request', $permissions) && session('role') !== 'employee')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin_leave_list') }}">
                                <i class="fab fa-pied-piper-alt menu-icon"></i>
                                <span class="menu-title">Leave Request <span
                                        class="badge badge-pill badge-warning font-weight-bold ml-2"
                                        style="padding:0.2rem .5rem">
                                        {{ $pendingLeavesCount }}
                                    </span></span>
                            </a>
                        </li>
                    @endif

                    @if (hasPermission('finance', $permissions) && session('role') !== 'employee')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin_expense_request') }}">
                                <i class="fas fa-money-bill-wave menu-icon"></i> <!-- Changed icon -->
                                <span class="menu-title">Expense Request
                                    <span class="badge badge-pill badge-warning font-weight-bold ml-2"
                                        style="padding:0.2rem .5rem">
                                        {{ $PendingExepenseCount }}
                                    </span>
                                </span>
                            </a>
                        </li>
                    @endif

                    @php

                        $hasEmployeePermission = hasPermission('employee', $permissions);
                        $hasFinancePermission = hasPermission('finance', $permissions);
                    @endphp

                    @if ($hasEmployeePermission || $hasFinancePermission)
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="collapse" href="#page-reports" aria-expanded="false"
                                aria-controls="page-reports">
                                <i class="fas fa-clipboard menu-icon"></i>
                                <span class="menu-title">Reports</span>
                                <i class="menu-arrow"></i>
                            </a>
                            <div class="collapse" id="page-reports">
                                <ul class="nav flex-column sub-menu">
                                    @if ($hasEmployeePermission)
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('employee_report') }}">
                                                Employee Report
                                            </a>
                                        </li>
                                    @endif
                                    @if ($hasFinancePermission)
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('finance_report') }}">
                                                Finance Report
                                            </a>
                                        </li>
                                    @endif
                                </ul>
                            </div>
                        </li>
                    @endif


                    @if (hasPermission('finance', $permissions))
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="collapse" href="#page-finance" aria-expanded="false"
                                aria-controls="page-finance">
                                <i class="fas fa-coins menu-icon"></i>
                                <span class="menu-title">Finance</span>
                                <i class="menu-arrow"></i>
                            </a>
                            <div class="collapse" id="page-finance">
                                <ul class="nav flex-column sub-menu">
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('income_list') }}">
                                            Income
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="{{ route('expense_list') }}">
                                            Expense
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif
                    @php
                        $hasSettingPermission = hasPermission('settings', $permissions);
                        $hasEmployeePermission = hasPermission('employee', $permissions);
                    @endphp

                    @if ($hasSettingPermission || $hasEmployeePermission)
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="collapse" href="#page-settings" aria-expanded="false"
                                aria-controls="page-settings">
                                <i class="fas fa-cog menu-icon"></i>
                                <span class="menu-title">Settings</span>
                                <i class="menu-arrow"></i>
                            </a>
                            <div class="collapse" id="page-settings">
                                <ul class="nav flex-column sub-menu">
                                    @if ($hasEmployeePermission)
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('job_type_list') }}">
                                                Job Type
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('salary_type_list') }}">
                                                Salary Type
                                            </a>
                                        </li>
                                    @endif

                                    @if ($hasSettingPermission)
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('allowance_list') }}">
                                                Allowances
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('loan_list') }}">
                                                Loan
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('increment_list') }}">
                                                Increment
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('deduction_list') }}">
                                                Deduction
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('tax_slab_list') }}">
                                                Tax Slab
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('bonus_list') }}">
                                                Bonus
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('leave_type_list') }}">
                                                Leave Type
                                            </a>
                                        </li>
                                    @endif
                                </ul>
                            </div>
                        </li>
                    @endif

                @endif
            </ul>
        </nav>
