@extends('admin.layout.main')
@section('content')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <div class="content-wrapper PrintBody">
        <div class="col-12">
            <img src="{{ asset('assets/images/hexon-logo.png') }}" class="img d-none" alt="Logo"
                style="width:100%; max-width:200px">
        </div>
        <div class="row page-header">
            <h3 class="col-md-6 page-title title">Employee Report</h3>
            <nav class="col-md-6 text-right" aria-label="breadcrumb">
                <button id="exportPaymentsButton" class="btn btn-primary btn-sm" data-toggle="modal"
                    data-target="#exportPaymentsModal">Export Payments</button>

                <button type="button" id="filter" class="btn btn-primary btn-sm" data-toggle="modal"
                    data-target="#Filter-modal"><i class="fa fa-filter mr-1"></i> Apply Filter</button>
            </nav>
            <nav class="col-12 title" aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a
                            style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Employee Report</li>
                </ol>
            </nav>
        </div>

        <div class="row">
            <div class="col-md-4 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title font-weight-bold mb-0">Total Net Pay</h4>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-inline-block pt-3">
                                <h2 class="mb-0">R.s {{ number_format($totals['total_net_pay'] ?? 0) }}</h2>
                            </div>
                            <div class="d-inline-block">
                                <i class="fas fa-chart-pie text-success" style="font-size: 50px" title="Total Income"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title font-weight-bold mb-0">Total Increments</h4>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-inline-block pt-3">
                                <h2 class="mb-0">R.s {{ number_format($totals['total_increments'] ?? 0) }}</h2>
                            </div>
                            <div class="d-inline-block">
                                <i class="fas fa-chart-line text-danger" style="font-size: 50px" title="Total Expense"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-4 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title font-weight-bold mb-0">Total Deductions</h4>
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-inline-block pt-3">
                                <h2 class="mb-0">R.s {{ number_format($totals['total_deductions'] ?? 0) }}</h2>
                            </div>
                            <div class="d-inline-block">
                                <i class="fas fa-money-bill-wave text-success" style="font-size: 50px"
                                    title="Total Deductions"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        {{-- Payments Table --}}
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div class="row px-3 py-3">
                            <div class="table-responsive" id="table">
                                <table id="order-listing" class="table">
                                    <thead>
                                        <tr>
                                            <th class="text-center">#</th>
                                            <th class="text-center">Employee Name</th>
                                            <th class="text-center">Salary Month</th>
                                            <th class="text-center">Salary (Rs)</th>
                                            <th class="text-center">Tax (Rs)</th>
                                            <th class="text-center">Details</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($payments as $payment)
                                            <tr>
                                                <td class="text-center">{{ $loop->iteration }}</td>
                                                <td class="text-center">{{ $payment['name'] }}</td>
                                                <td class="text-center">
                                                    {{ \Carbon\Carbon::parse($payment['salary_month'])->format('Y-m') }}
                                                </td>
                                                <td class="text-center"> {{ number_format($payment['net_pay_after_tax']) }}
                                                </td>
                                                <td class="text-center"> {{ number_format($payment['tax']) }}
                                                </td>
                                                <td class="text-center"> <button id="employeReportbtn"
                                                        class="btn btn-primary" data-id="{{ $payment['payment_id'] }}"> View
                                                        More</button></td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- Filter Modal --}}
    <div class="modal fade" id="Filter-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Filter Data</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('employee_report') }}" method="GET">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        <div class="form-group">
                            <label for="timeframe" class="font-weight-bold">Select Timeframe</label>
                            <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                                <label class="btn btn-outline-secondary active flex-fill">
                                    <input type="radio" name="timeframe" id="month-toggle" value="month" checked>
                                    Month
                                </label>
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="timeframe" id="year-toggle" value="year"> Year
                                </label>
                                <label class="btn btn-outline-secondary flex-fill">
                                    <input type="radio" name="timeframe" id="custom-toggle" value="custom"> Custom
                                </label>
                            </div>
                        </div>
                        <div class="form-group" id="month-group">
                            <label for="month" class="font-weight-bold">Select Month</label>
                            <input type="month" id="month" class="form-control" name="month" required>
                        </div>
                        <div class="form-group" id="year-group" style="display: none;">
                            <label for="year" class="font-weight-bold">Select Year</label>
                            <select id="year" class="form-control" name="year">
                                <option value="" disabled selected>Select Year</option>
                                @for ($i = date('Y') - 5; $i <= date('Y') + 5; $i++)
                                    <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                        <div id="custom-date-range" style="display: none;">
                            <div class="form-group">
                                <label for="start-date" class="font-weight-bold">Start Date</label>
                                <input type="date" id="start-date" class="form-control" name="start_date">
                            </div>
                            <div class="form-group">
                                <label for="end-date" class="font-weight-bold">End Date</label>
                                <input type="date" id="end-date" class="form-control" name="end_date">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Apply Filter</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div id="exportPaymentsModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Export Payments</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <label for="monthYear">Select Month :</label>
                    <input type="month" id="monthYear" class="form-control" required>

                </div>
                <div class="modal-footer" style="display: flex; justify-content:space-between">

                    <div>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button id="submitExportButton" class="btn btn-primary">Export</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Bootstrap Modal -->
    <div class="modal fade" id="updateUser" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="exampleModalLabel">Payment Details</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Name :</span>
                                <small class=""><span id="EmployeeName"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Email :</span>
                                <small class=""><span id="EmployeeEmail"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Cnic :</span>
                                <small class=""><span id="EmployeeCnic"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Gender :</span>
                                <small class=""><span id="EmployeeGender"></span></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Department
                                    :</span>
                                <small class=""><span id="EmployeeDepartment"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Designation
                                    :</span>
                                <small class=""><span id="EmployeeDesignation"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Shift :</span>
                                <small class=""><span id="EmployeeShift"></span></small>
                            </div>
                            <div>
                                <span style="font-weight: bolder" class="fw-bolder w-25 d-inline-block">Duty Time :</span>
                                <small class="">9:00 Hr</small>
                            </div>

                        </div>
                    </div>
                    <table class="table-bordered mt-4 table">
                        <thead class="bg-danger text-white">
                            <tr>
                                <th scope="col">Earnings</th>
                                <th scope="col">Amount</th>
                                <th class="text-dark bg-white text-center">-</th>
                                <th scope="col">Deductions</th>
                                <th scope="col">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Basic Salary</td>
                                <td>Rs <span id="modalBasicSalaray"></span> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Deductions</td>
                                <td>Rs <span id="modalDeductions"></span> -/<sub>only</sub></td>
                            </tr>
                            <tr>
                                <td>Allowance</td>
                                <td>Rs <span id="modalAllowances"></span> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Tax</td>
                                <td>Rs <span id="modalTax"></span> -/<sub>only</sub></td>
                            </tr>
                            <tr>
                                <td>Bonus Amount</td>
                                <td>Rs <span id="modalBonusAmount"></span> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Loan Amount</td>
                                <td>Rs <span id="modalLeaveDeduction"></span> -/<sub>only</sub></td>
                            </tr>
                            <tr>
                                <td>Increments</td>
                                <td>Rs <span id="modalIncrements"></span> -/<sub>only</sub></td>
                                <td class="text-center">-</td>
                                <td>Installments</td>
                                <td>Rs <span id="modal_loan_installment"></span> -/<sub>only</sub></td>
                            </tr>

                        </tbody>
                    </table>

                    <div class="row mb-3 mt-4">
                        <div class="col-md-6">
                            <div class="font-weight-bold p-2" style="font-size:20px;">
                                <span>Net Salary : </span>
                                <td>Rs <span id="modalNetPayAfterTax"></span> -/<sub>only</sub></td>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Toggle visibility of fields based on timeframe selection
            $('input[name="timeframe"]').change(function() {
                if ($('#month-toggle').is(':checked')) {
                    $('#month-group').show();
                    $('#month').prop('required', true); // Make month required
                    $('#year-group').hide();
                    $('#year').prop('required', false); // Remove required from year
                    $('#custom-date-range').hide();
                    $('#start-date').prop('required', false); // Remove required from custom range
                    $('#end-date').prop('required', false);
                } else if ($('#year-toggle').is(':checked')) {
                    $('#month-group').hide();
                    $('#month').prop('required', false);
                    $('#year-group').show();
                    $('#year').prop('required', true); // Make year required
                    $('#custom-date-range').hide();
                    $('#start-date').prop('required', false);
                    $('#end-date').prop('required', false);
                } else if ($('#custom-toggle').is(':checked')) {
                    $('#month-group').hide();
                    $('#month').prop('required', false);
                    $('#year-group').hide();
                    $('#year').prop('required', false);
                    $('#custom-date-range').show();
                    $('#start-date').prop('required', true); // Make custom range required
                    $('#end-date').prop('required', true);
                }
            });

            function number_format(number) {
                return new Intl.NumberFormat().format(number);
            }

            $('body').on('click', '#employeReportbtn', function() {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{ route('employee_report_details', ['id' => ':id']) }}".replace(':id',
                        id),
                    success: function(response) {
                        if (response.status === 404) {
                            $('#updateUser').modal('hide');
                            toastr.error('Payment not found.');
                        } else {
                            // Open modal
                            $('#updateUser').modal('show');

                            // Assuming the response contains the payment data
                            var payment = response[
                                0]; // Get the first (and presumably only) payment

                            $('#modalBasicSalaray').text(payment.employee.salary);
                            $('#modalSalaryMonth').text(payment.salary_month);
                            $('#modalNetPay').text(number_format(payment.net_pay_after_tax));
                            $('#modalAllowances').text(payment.allowances);
                            $('#modalDeductions').text(payment.deductions);
                            $('#modalLoanAmount').text(payment.loan_amount);
                            $('#modalBonusAmount').text(payment.bonus_amount);
                            $('#modalUnpaidLeaves').text(payment.unpaid_leaves);
                            $('#modalLeaveDeduction').text(payment.leave_deduction);
                            $('#modalTax').text(payment.tax);
                            $('#modalNetPayAfterTax').text(payment.net_pay_after_tax);
                            $('#modalIncrements').text(payment.increments);
                            $('#modal_loan_installment').text(payment.loan_installment);
                            $('#EmployeeName').text(payment.employee.user_profile.user.name);
                            $('#EmployeeEmail').text(payment.employee.user_profile.user.email);
                            $('#EmployeeCnic').text(payment.employee.user_profile.cnic);
                            $('#EmployeeGender').text(payment.employee.user_profile.gender);
                            $('#EmployeeDepartment').text(payment.employee.department
                                .department);
                            $('#EmployeeDesignation').text(payment.employee.designation
                                .designation);
                            $('#EmployeeShift').text(payment.employee.shift.shift);
                        }
                    },
                    error: function(xhr) {
                        toastr.error('An error occurred while fetching the payment.');
                    }
                });
            });


            $('#exportPaymentsButton').on('click', function() {
                $('#exportPaymentsModal').modal('show');
            });
            $('#submitExportButton').on('click', function() {
                const monthYear = $('#monthYear').val(); // Get the selected month

                if (!monthYear) {
                    toastr.error('Please select a month .');
                    return;
                }

                // Make the AJAX request
                $.ajax({
                    type: 'GET',
                    url: '{{ route('export_payments_download') }}', // Use the appropriate route for exporting payments
                    data: {
                        month: monthYear,
                        _token: '{{ csrf_token() }}' // Include CSRF token for security
                    },
                    xhrFields: {
                        responseType: 'blob' // Set response type to blob for file download
                    },
                    success: function(data, status, xhr) {
                        const filename = "payments.csv"; // Set the filename for the download

                        // Create a link to download the file
                        const blob = new Blob([data], {
                            type: 'text/csv'
                        });
                        const link = document.createElement('a');
                        link.href = window.URL.createObjectURL(blob);
                        link.download = filename;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link); // Clean up

                        toastr.success('Payments exported successfully!');
                    },
                    error: function(xhr) {
                        toastr.error('No Payments found for this month');
                    }
                });
            });


        });
    </script>
@endsection
