@extends('admin.layout.main')

@section('content')
    <div class="main-panel">
        <div class="content-wrapper">
            <div class="row page-header">
                <h3 class="col-md-6 page-title">
                    Income List
                </h3>
                <nav class="col-md-6 text-right" aria-label="breadcrumb">
                    <button data-bs-toggle="modal" id="add_income" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Create Income</button>
                    <button id="export_income" class="btn btn-sm btn-outline-primary">
                        <i class="fa fa-plus-circle mr-sm-2"></i>Export Incomes</button>
                </nav>
                <nav class="col-12" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                style="text-decoration: none; color:#392C70; font-size:15px; font-weight:600;">Dashboard</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page" style="font-size:15px;">Income List
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table id="income_table" class="data_table table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Amount</th>
                                            <th>Date</th>
                                            <th>Description</th>


                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="createIncome" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Add Income</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="addIncomeForm" method="POST">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf

                        <label>Amount</label>
                        <input class="form-control" type="number" id="amount" name="amount" placeholder="Enter amount"
                            required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="date" name="date" placeholder="Enter date"
                            required></input>


                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Add</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="updateIncome" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-2"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="padding:10px 26px !important">
                    <h4 id="exampleModalLabel-2">Update Income</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="updateIncomeForm">
                    <div class="modal-body" style="padding: 35px 15px !important">
                        @csrf
                        <input type="hidden" name="income_id" id="income_id">
                        <label>Amount</label>
                        <input class="form-control" type="number" id="update_amount" name="amount"
                            placeholder="Enter amount" required></input>

                        <label class="mt-4">Date</label>
                        <input class="form-control" type="date" id="update_date" name="date"
                            placeholder="Enter date" required></input>

                        <label class="mt-4">Description</label>
                        <textarea class="form-control" type="text" id="update_description" name="description" rows="5"
                            placeholder="Enter description" required></textarea>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update</button>
                        <button type="button" class="btn btn-light" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exportIncomeModal" tabindex="-1" role="dialog"
        aria-labelledby="exportIncomeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exportIncomeModalLabel">Export Income</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="exportIncomeForm">
                        @csrf
                        <div class="form-group">
                            <label for="month">Select Month</label>
                            <input type="month" class="form-control" id="month" name="month" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="exportIncomeButton">Export Income</button>
                </div>
            </div>
        </div>
    </div>
    @push('js')
        <script>
            $(document).ready(function() {
                $('#income_table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: '{{ route('income_list') }}',
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },

                        {
                            data: 'date',
                            name: 'date',
                            render: function(data) {
                                return new Date(data).toLocaleDateString('en-GB', {
                                    day: '2-digit',
                                    month: 'short',
                                    year: 'numeric'
                                });
                            }
                        },
                        {
                            data: 'description',
                            name: 'description'
                        },




                        {
                            data: null,
                            name: 'action',
                            render: function(data, type, row) {
                                return `
                        <div class="dropdown">
                            <a style="font-size: 19px; color:black; text-decoration: none;" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                ⋮
                            </a>

                            <div class="dropdown-menu"  aria-labelledby="dropdownMenuLink" x-placement="bottom-start" style="position: absolute; transform: translate3d(0px, 21px, 0px); top: 0px; left: 0px; will-change: transform;">
                                <button data-id="${row.id}" id="editincomebtn"  class="dropdown-item text-primary">
                                    <i class="fa fa-pen mr-2"></i> Edit
                                </button>
                                <button data-id="${row.id}" id="delete_income"  class="dropdown-item text-danger">
                                    <i class="far fa-trash-alt mr-2"></i> Delete
                                </button>
                            </div>
                        </div>
                    `;
                            }
                        }
                    ]
                });


                $('#export_income').on('click', function() {
                    $('#exportIncomeModal').modal('show');
                });

                $('#exportIncomeButton').on('click', function() {
                    $('#exportIncomeForm').submit();
                });

                $('#exportIncomeForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#exportIncomeButton');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'GET', // Keep it as GET if that's how your endpoint is set up
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('export_incomes_csv') }}",
                        data: $(this).serialize(),
                        xhrFields: {
                            responseType: 'blob' // Expecting a binary response for CSV
                        },
                        success: function(blob, status, xhr) {
                            const contentType = xhr.getResponseHeader('Content-Type');
                            const contentDisposition = xhr.getResponseHeader('Content-Disposition');

                            // Check if the response is actually a blob (CSV file)
                            if (contentType === 'text/csv' || contentDisposition.includes(
                                    'attachment')) {
                                const url = window.URL.createObjectURL(blob);
                                const a = document.createElement('a');
                                a.href = url;
                                a.download = 'income.csv'; // Set the filename for the download
                                document.body.appendChild(a);
                                a.click();
                                a.remove();
                                window.URL.revokeObjectURL(url); // Clean up the URL

                                $('#exportIncomeModal').modal('hide');
                                $('#exportIncomeForm')[0].reset();
                                toastr.success("Incomes Exported Successfully");
                            } else {
                                // Handle case where the response is not a blob
                                const response = JSON.parse(blob);
                                if (response.message) {
                                    toastr.error(response.message);
                                } else {
                                    toastr.error('Unexpected response from server.');
                                }
                            }
                        },
                        error: function(xhr) {
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                toastr.error(xhr.responseJSON.message);
                            } else {
                                toastr.error('No incomes Found for this month');
                            }
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });


                $('#add_income').on('click', function() {
                    $('#createIncome').modal('show');
                });
                $('#addIncomeForm').on('submit', function(e) {
                    e.preventDefault();

                    let $submitButton = $('#addIncomeForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('add_income_form') }}",
                        data: $(this).serialize(),
                        success: function(response) {
                            if (response.success) {
                                $('#createIncome').modal('hide');
                                $('#income_table').DataTable().ajax.reload();
                                $('#addIncomeForm')[0].reset();
                                toastr.success(response.message);
                            } else {
                                let errorMessage = response.message;
                                if (response.errors) {
                                    errorMessage += '<br><br>Errors:<ul>';
                                    $.each(response.errors, function(key, errors) {
                                        $.each(errors, function(index, error) {
                                            errorMessage += '<li>' + error +
                                                '</li>';
                                        });
                                    });
                                    errorMessage += '</ul>';
                                }
                                toastr.error(errorMessage);
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr);
                            toastr.error('Invalid Details '); // General error message
                        },
                        complete: function() {
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

                $('body').on('click', '#delete_income', function() {
                    var id = $(this).data('id');

                    $.ajax({
                        type: "DELETE",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('delete_income', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {
                            $('#income_table').DataTable().ajax.reload();
                            // Show success Toastr message
                            toastr.success('Income deleted successfully');
                        },
                        error: function(xhr) {
                            // Display error Toastr message
                            let errorMessage = 'An error occurred while deleting the Income.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage);
                        }
                    });
                });

                $('body').on('click', '#editincomebtn', function() {
                    var id = $(this).data('id');



                    $.ajax({
                        type: "GET",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('get_expense', ['id' => ':id']) }}"
                            .replace(':id', id),
                        success: function(response) {

                            if (response.status === 404) {
                                $('#updateIncome').modal('hide');
                                toastr.error('Income not found.');
                            } else {
                                $('#updateIncome').modal('show');
                                var income =
                                    response;
                                console.log(income); // response is already the department data
                                $('#income_id').val(income.id);
                                // $('#update_employee_id').val(income.empoyee_id);
                                $('#update_amount').val(income.amount);
                                $('#update_date').val(income.date);

                                $('#update_description').val(income.description);
                            }
                        },
                        error: function(xhr) {

                            toastr.error('An error occurred while fetching the Income.');
                        }
                    });
                });

                $('#updateIncomeForm').on('submit', function(e) {
                    e.preventDefault();

                    var id = $('#income_id').val(); // Use the correct ID

                    // Disable the submit button to prevent multiple submissions
                    let $submitButton = $('#updateIncomeForm button[type="submit"]');
                    $submitButton.prop('disabled', true);

                    $.ajax({
                        type: 'PUT',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        url: "{{ route('update_income_form', ['id' => ':id']) }}".replace(':id',
                            id),
                        data: $(this).serialize(),
                        success: function(response) {
                            console.log("AJAX Success:", response); // Log response for debugging

                            if (response.success) {
                                $('#updateIncome').modal('hide');
                                $('#income_table').DataTable().ajax
                                    .reload(); // Reload DataTable
                                toastr.success(response.message);
                                $('#updateIncomeForm')[0].reset();
                            } else {
                                // Handle validation or other errors
                                let errorMessage = response.message || 'An error occurred.';
                                toastr.error(errorMessage); // Display error
                            }
                        },
                        error: function(xhr) {
                            console.log("AJAX Error:", xhr); // Log the error for debugging
                            let errorMessage = 'An unexpected error occurred.';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                errorMessage = xhr.responseJSON.message;
                            }
                            toastr.error(errorMessage); // Display error
                        },
                        complete: function() {
                            // Re-enable the submit button after the request completes
                            $submitButton.prop('disabled', false);
                        }
                    });
                });

            });
        </script>
    @endpush
@endsection
